/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import org.refcodes.data.Encoding;
import org.refcodes.exception.RuntimeIOException;
import org.refcodes.mixin.EncodingAccessor;
import org.refcodes.mixin.InputStreamAccessor;

public class InputStreamStringBuilder
implements InputStreamAccessor.InputStreamProperty,
InputStreamAccessor.InputStreamBuilder<InputStreamStringBuilder>,
EncodingAccessor.EncodingProperty<String>,
EncodingAccessor.EncodingBuilder<String, InputStreamStringBuilder> {
    private InputStream _inputStream = null;
    private String _lines = null;
    private String _encoding = Encoding.UTF_8.getCode();

    public InputStreamStringBuilder withEncoding(String aEncoding) {
        this.setEncoding(aEncoding);
        return this;
    }

    public InputStreamStringBuilder withInputStream(InputStream aInputStream) {
        this.setInputStream(aInputStream);
        return this;
    }

    public String toString(InputStream aInputStream) throws IOException {
        return this.toString(aInputStream, this.getEncoding());
    }

    public String[] toStrings(InputStream aInputStream) throws IOException {
        return this.toString(aInputStream, this.getEncoding()).split("\\r\\n|\\n|\\r");
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String aEncoding) {
        this._encoding = aEncoding;
    }

    public InputStream getInputStream() {
        return this._inputStream;
    }

    public void setInputStream(InputStream aInputStream) {
        this._inputStream = aInputStream;
        this._lines = null;
    }

    public String toString(InputStream aInputStream, String aEncoding) throws IOException {
        if (aInputStream == null) {
            return null;
        }
        try (Scanner theScanner = new Scanner(aInputStream, aEncoding);){
            theScanner.useDelimiter("\\A");
            String string = theScanner.hasNext() ? theScanner.next() : "";
            return string;
        }
    }

    public String toString() {
        try {
            return this.toString(this._encoding);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public String toString(String aEncoding) throws IOException {
        if (this._lines == null) {
            this._lines = this.toString(this._inputStream, aEncoding);
        }
        return this._lines;
    }

    public String[] toStrings() throws IOException {
        return this.toStrings(this.getEncoding());
    }

    public String[] toStrings(String aEncoding) throws IOException {
        return this.toString(aEncoding).split("\\r\\n|\\n|\\r");
    }

    public String[] toStrings(InputStream aInputStream, String aEncoding) throws IOException {
        return this.toString(aInputStream, aEncoding).split("\\r\\n|\\n|\\r");
    }
}

