/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import org.refcodes.data.IoSleepLoopTime;
import org.refcodes.exception.TimeoutIOException;
import org.refcodes.mixin.ResultAccessor;

public interface IOResultAccessor<RES, EXC extends Exception>
extends ResultAccessor<RES, EXC> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void waitForResult(long aTimeoutMillis) throws InterruptedException, TimeoutIOException {
        long theStartTime = System.currentTimeMillis();
        long theWaitTimeInMs = aTimeoutMillis / 100L;
        if (theWaitTimeInMs < (long)IoSleepLoopTime.MIN.getTimeMillis()) {
            theWaitTimeInMs = IoSleepLoopTime.MIN.getTimeMillis();
        }
        if (theWaitTimeInMs > aTimeoutMillis) {
            theWaitTimeInMs = aTimeoutMillis;
        }
        while (!this.hasResult() && System.currentTimeMillis() - theStartTime < aTimeoutMillis) {
            IOResultAccessor iOResultAccessor = this;
            synchronized (iOResultAccessor) {
                this.wait(theWaitTimeInMs);
            }
        }
        if (!this.hasResult() && !this.hasResult()) {
            throw new TimeoutIOException(aTimeoutMillis, "Unable to retrieve a result after a timeout of <" + aTimeoutMillis + "> milliseconds.");
        }
    }
}

