/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.refcodes.io.ZipUtility;

public class ZipFileOutputStream
extends BufferedOutputStream {
    public ZipFileOutputStream(File parent, String child) throws ZipException, FileNotFoundException, IOException {
        this(new File(parent, child));
    }

    public ZipFileOutputStream(String parent, String child) throws ZipException, FileNotFoundException, IOException {
        this(new File(parent, child));
    }

    public ZipFileOutputStream(String pathname) throws ZipException, FileNotFoundException, IOException {
        this(new File(pathname));
    }

    public ZipFileOutputStream(URI uri) throws ZipException, FileNotFoundException, IOException {
        this(new File(uri));
    }

    public ZipFileOutputStream(File aFile) throws ZipException, FileNotFoundException, IOException {
        super(ZipFileOutputStream.toOutputStream(aFile));
    }

    protected static OutputStream toOutputStream(File aFile) throws ZipException, IOException, FileNotFoundException {
        String theUnZipFileName = ZipUtility.toFileNameFromZip(aFile.getName());
        if (theUnZipFileName != null) {
            BufferedOutputStream theFileOutputStream = new BufferedOutputStream(new FileOutputStream(aFile));
            ZipOutputStream theZipOutputStream = new ZipOutputStream(theFileOutputStream);
            ZipEntry theZipEntry = new ZipEntry(theUnZipFileName);
            theZipOutputStream.putNextEntry(theZipEntry);
            return theZipOutputStream;
        }
        return new BufferedOutputStream(new FileOutputStream(aFile));
    }
}

