/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.io.ShortReceiver;
import org.refcodes.io.ShortsDestination;

public interface ShortsReceiver
extends ShortsDestination,
ShortReceiver {
    @Override
    default public short[] receiveAllShorts() throws IOException {
        ArrayList<Short> theData = new ArrayList<Short>();
        while (this.hasAvailable()) {
            theData.add(this.receiveShort());
        }
        short[] theShorts = new short[theData.size()];
        for (int i = 0; i < theShorts.length; ++i) {
            theShorts[i] = (Short)theData.get(i);
        }
        return theShorts;
    }

    @Override
    default public short[] receiveShorts(int aMaxLength) throws IOException {
        int i;
        short[] theBlock = new short[aMaxLength];
        for (i = 0; this.hasAvailable() && i < aMaxLength; ++i) {
            theBlock[i] = this.receiveShort();
        }
        if (i == 0) {
            while (!this.hasAvailable()) {
                try {
                    Thread.sleep(SleepLoopTime.NORM.getTimeInMs());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (this.hasAvailable() && i < aMaxLength) {
                    theBlock[i] = this.receiveShort();
                    ++i;
                }
            }
        }
        if (i == aMaxLength) {
            return theBlock;
        }
        return Arrays.copyOfRange(theBlock, 0, i);
    }
}

