/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.io.AbstractDatagramsTransmitter;
import org.refcodes.io.ConnectionDatagramsTransmitter;

public class OutputStreamConnectionDatagramsTransmitter<DATA extends Serializable>
extends AbstractDatagramsTransmitter<DATA>
implements ConnectionDatagramsTransmitter<DATA, OutputStream> {
    private ObjectOutputStream _objectOutputStream = null;

    public synchronized void open(OutputStream aOutputStream) throws IOException {
        if (this.isOpened()) {
            throw new IOException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        try {
            this._objectOutputStream = aOutputStream instanceof ObjectOutputStream ? (ObjectOutputStream)aOutputStream : (!(aOutputStream instanceof BufferedOutputStream) ? new ObjectOutputStream(new BufferedOutputStream(aOutputStream)) : new ObjectOutputStream(aOutputStream));
            this._objectOutputStream.flush();
        }
        catch (IOException aException) {
            throw new IOException("Unable to open the I/O stream receiver as of a causing exception.", aException);
        }
        this.setConnectionStatus(ConnectionStatus.OPENED);
    }

    public boolean isOpenable(OutputStream aOutputStream) {
        if (aOutputStream == null) {
            return false;
        }
        return !this.isOpened();
    }

    @Override
    public void flush() throws IOException {
        try {
            this._objectOutputStream.flush();
        }
        catch (IOException e) {
            throw new IOException("Unable to flush underlying output stream <" + this._objectOutputStream + ">.", e);
        }
    }

    public synchronized void close() throws IOException {
        super.close();
        try {
            this._objectOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transmit(DATA aDatagram) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to write datagram <" + aDatagram.getClass().getName() + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        ObjectOutputStream objectOutputStream = this._objectOutputStream;
        synchronized (objectOutputStream) {
            try {
                this._objectOutputStream.writeObject(aDatagram);
                this._objectOutputStream.flush();
            }
            catch (IOException aException) {
                if (this.isClosed()) {
                    return;
                }
                try {
                    this.close();
                }
                catch (IOException e) {
                    throw new IOException("Unable to close malfunctioning connection.", e);
                }
                throw new IOException(aException);
            }
        }
    }
}

