/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.io.AbstractBytesTransmitter;
import org.refcodes.io.ConnectionBytesTransmitter;

public class OutputStreamConnectionBytesTransmitter
extends AbstractBytesTransmitter
implements ConnectionBytesTransmitter<OutputStream> {
    private OutputStream _outputStream = null;

    public synchronized void open(OutputStream aOutputStream) throws IOException {
        if (this.isOpened()) {
            throw new IOException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        try {
            this._outputStream = aOutputStream;
            this._outputStream.flush();
        }
        catch (IOException aException) {
            throw new IOException("Unable to open the I/O stream receiver as of a causing exception.", aException);
        }
        this.setConnectionStatus(ConnectionStatus.OPENED);
    }

    public boolean isOpenable(OutputStream aOutputStream) {
        if (aOutputStream == null) {
            return false;
        }
        return !this.isOpened();
    }

    @Override
    public void flush() throws IOException {
        try {
            this._outputStream.flush();
        }
        catch (IOException e) {
            throw new IOException("Unable to flush underlying output stream <" + this._outputStream + ">.", e);
        }
    }

    public synchronized void close() throws IOException {
        super.close();
        try {
            this._outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transmitByte(byte aByte) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to write datagram <" + aByte + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        OutputStream outputStream = this._outputStream;
        synchronized (outputStream) {
            try {
                this._outputStream.write(aByte);
                this._outputStream.flush();
            }
            catch (IOException aException) {
                if (this.isClosed()) {
                    return;
                }
                try {
                    this.close();
                }
                catch (IOException e) {
                    throw new IOException("Unable to close malfunctioning connection.", e);
                }
                throw new IOException(aException);
            }
        }
    }
}

