/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.data.SystemProperty;

public class LineBreakOutputStream
extends OutputStream {
    private long _count = 0L;
    private String _lineBreak;
    private int _lineWidth;
    private OutputStream _outputStream;

    public LineBreakOutputStream(OutputStream aOutputStream, int aLineWidth, String aLineBreak) {
        this._lineBreak = aLineBreak;
        this._lineWidth = aLineWidth;
        this._outputStream = aOutputStream;
    }

    public LineBreakOutputStream(OutputStream aOutputStream, int aLineWidth) {
        this._lineBreak = SystemProperty.LINE_SEPARATOR.getValue();
        this._lineWidth = aLineWidth;
        this._outputStream = aOutputStream;
    }

    @Override
    public void write(int aByte) throws IOException {
        ++this._count;
        this._outputStream.write(aByte);
        if (this._lineWidth != -1 && this._count % (long)this._lineWidth == 0L) {
            this._outputStream.write(this._lineBreak.getBytes());
            this._count = 0L;
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    @Override
    public void close() throws IOException {
        if (this._lineWidth != -1) {
            if (this._count % (long)this._lineWidth != 0L) {
                this._outputStream.write(this._lineBreak.getBytes());
                this._count = 0L;
            }
            super.close();
        }
    }
}

