/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.PixmapImageBuilder;
import org.refcodes.graphical.RgbPixel;
import org.refcodes.graphical.RgbPixmap;
import org.refcodes.graphical.RgbPixmapImpl;

public class RgbPixmapImageBuilder
implements PixmapImageBuilder<RgbPixel> {
    private InputStream _imageStream = null;
    private URL _imageUrl = null;
    private int _width = -1;
    private int _height = -1;

    @Override
    public int getWidth() {
        return this._width;
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    @Override
    public void setDimension(int n, int n2) {
        this._width = n;
        this._height = n2;
    }

    @Override
    public void setDimension(Dimension dimension) {
        this._width = dimension.getWidth();
        this._height = dimension.getHeight();
    }

    @Override
    public void setWidth(int n) {
        this._width = n;
    }

    @Override
    public void setHeight(int n) {
        this._height = n;
    }

    @Override
    public RgbPixmapImageBuilder withDimension(int n, int n2) {
        this.setDimension(n, n2);
        return this;
    }

    @Override
    public RgbPixmapImageBuilder withDimension(Dimension dimension) {
        this.setDimension(dimension);
        return this;
    }

    @Override
    public RgbPixmapImageBuilder withWidth(int n) {
        this.setWidth(n);
        return this;
    }

    @Override
    public RgbPixmapImageBuilder withHeight(int n) {
        this.setHeight(n);
        return this;
    }

    @Override
    public void setImageInputStream(InputStream inputStream) {
        this._imageStream = inputStream;
        this._imageUrl = null;
    }

    @Override
    public void setImageURL(URL uRL) {
        this._imageStream = null;
        this._imageUrl = uRL;
    }

    public RgbPixmap toPixmap() throws IOException {
        if (this._imageUrl != null) {
            return new RgbPixmapImpl(this._imageUrl, this._width, this._height);
        }
        if (this._imageStream != null) {
            return new RgbPixmapImpl(this._imageStream, this._width, this._height);
        }
        throw new IllegalStateException("Either an image URL or an image Input-Stream (File) must be set to produce a pixmap!");
    }

    public RgbPixmap toPixmap(InputStream inputStream) throws IOException {
        return new RgbPixmapImpl(inputStream, this._width, this._height);
    }

    public RgbPixmapImageBuilder withImageInputStream(InputStream inputStream) {
        this.setImageInputStream(inputStream);
        return this;
    }

    public RgbPixmapImageBuilder withImageFile(File file) throws FileNotFoundException {
        this.setImageFile(file);
        return this;
    }

    public RgbPixmapImageBuilder withImageURL(URL uRL) {
        this.setImageURL(uRL);
        return this;
    }

    public RgbPixmap toPixmap(File file) throws IOException {
        return new RgbPixmapImpl(file);
    }
}

