/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.GridHeightAccessor;
import org.refcodes.graphical.GridWidthAccessor;
import org.refcodes.graphical.Position;

public interface GridDimension
extends GridHeightAccessor,
GridWidthAccessor {
    default public boolean isInBounds(Position position) {
        return this.isInBounds(position.getPositionX(), position.getPositionY());
    }

    default public boolean isInBounds(int n, int n2) {
        return n < this.getGridWidth() && n2 < this.getGridHeight() && n >= 0 && n2 >= 0;
    }

    default public boolean isInWidth(int n) {
        return n < this.getGridWidth() && n >= 0;
    }

    default public boolean isInHeight(int n) {
        return n < this.getGridHeight() && n >= 0;
    }

    public static boolean equals(GridDimension gridDimension, GridDimension gridDimension2) {
        return gridDimension.getGridWidth() == gridDimension2.getGridWidth() && gridDimension.getGridHeight() == gridDimension2.getGridHeight();
    }

    public static interface GridDimensionProperty
    extends GridDimension,
    GridDimensionMutator,
    GridWidthAccessor.GridWidthProperty,
    GridHeightAccessor.GridHeightProperty {
        default public GridDimension letGridDimension(GridDimension gridDimension) {
            this.setGridDimension(gridDimension);
            return gridDimension;
        }

        default public Dimension letGridDimension(Dimension dimension) {
            this.setGridDimension(dimension);
            return dimension;
        }

        default public GridDimension letGridDimension(final int n, final int n2) {
            this.setGridDimension(n, n2);
            return new GridDimension(){

                @Override
                public int getGridWidth() {
                    return n;
                }

                @Override
                public int getGridHeight() {
                    return n2;
                }
            };
        }
    }

    public static interface GridDimensionBuilder<B extends GridDimensionBuilder<B>>
    extends GridWidthAccessor.GridWidthBuilder<B>,
    GridHeightAccessor.GridHeightBuilder<B> {
        public B withGridDimension(int var1, int var2);

        public B withGridDimension(GridDimension var1);

        public B withGridDimension(Dimension var1);
    }

    public static interface GridDimensionMutator
    extends GridHeightAccessor.GridHeightMutator,
    GridWidthAccessor.GridWidthMutator {
        public void setGridDimension(int var1, int var2);

        public void setGridDimension(GridDimension var1);

        public void setGridDimension(Dimension var1);
    }
}

