/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.generator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.generator.BufferedGenerator;
import org.refcodes.mixin.DecorateeAccessor;
import org.refcodes.mixin.Disposable;

public class ConcurrentBufferedGeneratorDecorator<T>
implements BufferedGenerator<T>,
DecorateeAccessor<Iterator<T>>,
Disposable {
    private static final int POLL_QUEUE_LOOP_TIME_MILLIS = SleepLoopTime.MIN.getTimeMillis();
    private static final Logger LOGGER = Logger.getLogger(ConcurrentBufferedGeneratorDecorator.class.getName());
    private static final int DEFAULT_MAX_BUFFER_SIZE = 0x100000;
    private static final int DEFAULT_BUFFER_THRESHOLD = 524288;
    private static final int DEFAULT_REFILL_LOOP_TIME_MILLIS = DaemonLoopSleepTime.MIN.getTimeMillis();
    private Iterator<T> _decoratee;
    private int _bufferThreshold;
    private int _maxBufferSize;
    private long _refillLoopTimeMillis;
    private BlockingQueue<T> _queue;
    private final ThreadLocal<T> _next = new ThreadLocal();
    private boolean _isDisposed = false;
    private boolean _isSuspended = false;
    private boolean _isExhausted = false;
    private boolean _isDaemon;
    private Timer _timer;
    private RefillTask _timerTask;
    private boolean _isAdaptive;

    public ConcurrentBufferedGeneratorDecorator(Iterator<T> aDecoratee) {
        this(aDecoratee, 0x100000, 524288, DEFAULT_REFILL_LOOP_TIME_MILLIS, true, true);
    }

    public ConcurrentBufferedGeneratorDecorator(Iterator<T> aDecoratee, int aMaxBufferSize, int aBufferThreshold, long aRefillLoopSleepTimeMillis, boolean isAdaptive, boolean isDaemon) {
        this._decoratee = aDecoratee;
        this._bufferThreshold = aBufferThreshold;
        this._maxBufferSize = aMaxBufferSize;
        this._refillLoopTimeMillis = aRefillLoopSleepTimeMillis;
        this._isAdaptive = isAdaptive;
        this._queue = new LinkedBlockingQueue<T>(aMaxBufferSize);
        this._isDaemon = isDaemon;
        this.refill();
    }

    @Override
    public boolean hasNext() {
        if (this._next.get() != null) {
            return true;
        }
        try {
            T theNext;
            while (!((theNext = this._queue.poll(POLL_QUEUE_LOOP_TIME_MILLIS, TimeUnit.MILLISECONDS)) != null || this._isExhausted || this._isDisposed || this._isSuspended)) {
            }
            if (theNext == null) {
                return false;
            }
            this._next.set(theNext);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public T next() {
        T theNext = this._next.get();
        if (theNext != null) {
            this._next.set(null);
            return theNext;
        }
        try {
            do {
                if ((theNext = this._queue.poll(POLL_QUEUE_LOOP_TIME_MILLIS, TimeUnit.MILLISECONDS)) == null) continue;
                return theNext;
            } while (theNext == null && !this._isExhausted && !this._isDisposed && !this._isSuspended);
        }
        catch (Exception e) {
            throw new NoSuchElementException("Cannot retrieve next element from buffer!", e);
        }
        throw new NoSuchElementException("No more elements neither can be generated nor were found left in the queue!");
    }

    public Iterator<T> getDecoratee() {
        return this._decoratee;
    }

    public synchronized void suspend() {
        this._isSuspended = true;
        this._timer.cancel();
    }

    public synchronized void dispose() {
        this._isDisposed = true;
        this._isExhausted = true;
        this._isSuspended = true;
        this._timer.cancel();
        this._queue.clear();
    }

    private void refill() {
        if (!this._isDisposed && !this._isSuspended) {
            if (this._queue.isEmpty() && this._timer != null) {
                LOGGER.log(Level.WARNING, "Queue of <" + ConcurrentBufferedGeneratorDecorator.class.getSimpleName() + "> is running dry (empty) with refill loop time <" + this._refillLoopTimeMillis + "> ms, a max buffer size <" + this._maxBufferSize + "> and a threshold of <" + this._bufferThreshold + ">!" + (String)(this._isAdaptive ? " (adjusting refill loop time to <" + (this._refillLoopTimeMillis - this._refillLoopTimeMillis / 3L) + "> ms)" : ""));
            }
            if (this._isAdaptive && this._queue.isEmpty()) {
                this._refillLoopTimeMillis -= this._refillLoopTimeMillis / 3L;
            }
            if (this._queue.size() < this._bufferThreshold) {
                while (this._decoratee.hasNext() && this._queue.size() < this._maxBufferSize && !this._isSuspended && !this._isDisposed) {
                    try {
                        this._queue.put(this._decoratee.next());
                    }
                    catch (InterruptedException e) {
                        if (this._isDisposed || this._isSuspended) {
                            return;
                        }
                        break;
                    }
                }
            } else if (this._isAdaptive) {
                this._refillLoopTimeMillis += this._refillLoopTimeMillis / 3L;
            }
            if (this._decoratee.hasNext()) {
                if (!this._isSuspended && !this._isDisposed) {
                    this._timerTask = new RefillTask();
                    this._timer = new Timer(this._isDaemon);
                    this._timer.schedule((TimerTask)this._timerTask, this._refillLoopTimeMillis);
                }
            } else {
                this._isExhausted = true;
            }
        }
    }

    private class RefillTask
    extends TimerTask {
        private RefillTask() {
        }

        @Override
        public void run() {
            ConcurrentBufferedGeneratorDecorator.this.refill();
        }
    }
}

