/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.factory;

import java.util.Map;
import org.refcodes.exception.UnmarshalException;

@FunctionalInterface
public interface UnmarshalFactory<SRC> {
    public <T> T toUnmarshaled(SRC var1, Class<T> var2) throws UnmarshalException;

    default public Object toUnmarshaled(SRC aContext, Class<?> ... aTypes) throws UnmarshalException {
        for (Class<?> eType : aTypes) {
            try {
                return this.toUnmarshaled(aContext, (Class<T>)eType);
            }
            catch (UnmarshalException unmarshalException) {
            }
        }
        throw new UnmarshalException("Unable to unmarshal the context of type <" + aContext.getClass().getName() + "> to fit into one of the provided types.");
    }

    default public Object toUnmarshaled(SRC aContext, Map<String, String> aProperties, Class<?> ... aTypes) throws UnmarshalException {
        for (Class<?> eType : aTypes) {
            try {
                return this.toUnmarshaled(aContext, aProperties, eType);
            }
            catch (UnmarshalException unmarshalException) {
            }
        }
        throw new UnmarshalException("Unable to unmarshal the context of type <" + aContext.getClass().getName() + "> to fit into one of the provided types.");
    }

    default public <T> T toUnmarshaled(SRC aContext, Class<T> aType, Map<String, String> aProperties) throws UnmarshalException {
        return this.toUnmarshaled(aContext, aType);
    }

    public static interface UnmarshalFactoryComposite<T, C>
    extends UnmarshalFactory<T>,
    UnmarshalFactoryComplement<C> {
    }

    public static interface UnmarshalFactoryComplement<C> {
        public <T> T fromMarshaled(C var1, Class<T> var2) throws UnmarshalException;

        public Object fromMarshaled(C var1, Class<?> ... var2) throws UnmarshalException;

        public Object fromMarshaled(C var1, Map<String, String> var2, Class<?> ... var3) throws UnmarshalException;

        public <T> T fromMarshaled(C var1, Class<T> var2, Map<String, String> var3) throws UnmarshalException;
    }
}

