/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.factory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.refcodes.factory.TypeFactory;

public class PrototypeFactory<T>
implements TypeFactory<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private T _prototype;

    public PrototypeFactory(T aPrototype) {
        if (!(aPrototype instanceof Serializable) && !(aPrototype instanceof Cloneable)) {
            throw new IllegalArgumentException("Your type <" + aPrototype.getClass().getName() + "> must either implement the <Serializable> (defaults to a deep copy) or the <Cloneable> (defaults to a shallow copy interface.");
        }
        this._prototype = aPrototype;
    }

    @Override
    public T createInstance() {
        IllegalStateException theException = null;
        if (this._prototype instanceof Cloneable) {
            try {
                return (T)this._prototype.getClass().getMethod("clone", new Class[0]).invoke(this._prototype, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                theException = new IllegalStateException("Prototype of type <" + this.getType() + "> is un-cloneable as of: " + e.getMessage(), e);
            }
        }
        if (this._prototype instanceof Serializable) {
            try {
                ByteArrayOutputStream theByteArrayOut = new ByteArrayOutputStream();
                ObjectOutputStream theObjOut = new ObjectOutputStream(theByteArrayOut);
                theObjOut.writeObject(this._prototype);
                byte[] bytes = theByteArrayOut.toByteArray();
                ObjectInputStream theObjIn = new ObjectInputStream(new ByteArrayInputStream(bytes));
                return (T)theObjIn.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                throw new IllegalStateException("Prototype of type <" + this.getType() + "> is un-cloneable as of: " + e.getMessage(), e);
            }
        }
        throw theException != null ? theException : new IllegalStateException("Prototype of type <" + this.getType() + "> is un-cloneable.");
    }

    @Override
    public Class<T> getType() {
        return this._prototype.getClass();
    }
}

