/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow;

import org.refcodes.controlflow.Retryable;
import org.refcodes.mixin.RetryCountAccessor;
import org.refcodes.mixin.RetryNumberAccessor;

public class RetryCounter
implements Retryable,
RetryNumberAccessor,
RetryCountAccessor {
    private int _retryNumber;
    private long _retryDelayInMs;
    private long _expRetryDelayExtensionInMs;
    private int _retryCount = 0;
    private long _currentRetryDelayInMs = 0L;

    public RetryCounter(int aRetryNumber) {
        this(aRetryNumber, -1L, 0L);
    }

    public RetryCounter(long aTotalDelayInMs, long aRetryDelayInMs) {
        this((int)(aTotalDelayInMs / aRetryDelayInMs), aRetryDelayInMs, 0L);
    }

    public RetryCounter(int aRetryNumber, long aRetryDelayInMs) {
        this(aRetryNumber, aRetryDelayInMs, 0L);
    }

    public RetryCounter(int aRetryNumber, long aRetryDelayInMs, long aExpRetryDelayExtensionInMs) {
        this._retryNumber = aRetryNumber;
        this._retryDelayInMs = aRetryDelayInMs;
        this._expRetryDelayExtensionInMs = aExpRetryDelayExtensionInMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nextRetry() {
        if (this.hasNextRetry()) {
            if (this._retryCount != 0) {
                this._currentRetryDelayInMs = this.getNextRetryDelayInMs();
                if (this._currentRetryDelayInMs > 0L) {
                    RetryCounter retryCounter = this;
                    synchronized (retryCounter) {
                        try {
                            Thread.sleep(this._currentRetryDelayInMs);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this._retryNumber != -1) {
                ++this._retryCount;
            }
            return true;
        }
        this._currentRetryDelayInMs = 0L;
        return false;
    }

    public long getNextRetryDelayInMs() {
        if (!this.hasNextRetry() || this._retryNumber == 1) {
            return 0L;
        }
        long theCurrentRetryDelayInMs = this._currentRetryDelayInMs;
        theCurrentRetryDelayInMs = this._expRetryDelayExtensionInMs > 0L && (this._retryCount > 1 || this.getInitialRetryDelayInMs() == 0L) ? (long)((double)this._retryDelayInMs + Math.pow(4.0, this._retryCount - 1) * (double)this._expRetryDelayExtensionInMs) : this._retryDelayInMs;
        return theCurrentRetryDelayInMs;
    }

    @Override
    public boolean hasNextRetry() {
        return this._retryCount < this._retryNumber || this._retryNumber == -1 && this._retryCount != -1;
    }

    public void restart() {
        this._retryCount = 0;
        this._currentRetryDelayInMs = 0L;
    }

    public void abort() {
        this._retryCount = this._retryNumber;
    }

    public int getRetryNumber() {
        return this._retryNumber;
    }

    public long getInitialRetryDelayInMs() {
        return this._retryDelayInMs;
    }

    public long getCurrentRetryDelayInMs() {
        return this._currentRetryDelayInMs;
    }

    public long getExpRetryDelayExtensionInMs() {
        return this._expRetryDelayExtensionInMs;
    }

    @Override
    public int getRetryCount() {
        return this._retryCount;
    }

    public void setRetryDelayInMs(long aRetryDelayInMs) {
        this._retryDelayInMs = aRetryDelayInMs;
    }
}

