/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard.alt.javafx;

import java.util.logging.Level;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.GridDimensionChangedEvent;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.ViewportDimensionChangedEvent;
import org.refcodes.checkerboard.alt.javafx.FxCheckerboardViewer;
import org.refcodes.graphical.FieldDimension;
import org.refcodes.graphical.GridDimension;
import org.refcodes.graphical.ViewportDimension;

@Deprecated
class FxCheckerboardWindow<P extends Player<P, S>, S>
extends FxCheckerboardViewer<P, S> {
    private Stage _stage;
    private Scene _scene;
    private int _resizeGridMillis = 500;
    private ChangeListener<Number> _onWindowHeightChangedEventHandler = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number aOldValue, Number aNewValue) {
            if (Double.isNaN(FxCheckerboardWindow.this._bordersV) && !Double.isNaN(aOldValue.doubleValue())) {
                FxCheckerboardWindow.this.initBordersV(aOldValue.doubleValue());
                FxCheckerboardWindow.this.initMinStageHeight();
            }
            switch (FxCheckerboardWindow.this.getScaleMode()) {
                case GRID: {
                    int theNewViewportHeight = FxCheckerboardWindow.this.toScaledViewportDimension(aNewValue.doubleValue(), FxCheckerboardWindow.this.getViewportHeight(), FxCheckerboardWindow.this.getFieldHeight(), FxCheckerboardWindow.this.getFieldGap(), FxCheckerboardWindow.this._bordersV + FxCheckerboardWindow.this._windowDecorationV);
                    if (theNewViewportHeight == -1) break;
                    LOGGER.log(Level.FINE, "Viewport height changed to := " + theNewViewportHeight);
                    FxCheckerboardWindow.this.setViewportHeight(theNewViewportHeight);
                    break;
                }
                case FIELDS: {
                    int theNewFieldHeight = FxCheckerboardWindow.this.toScaledFieldDimension(aNewValue.doubleValue(), FxCheckerboardWindow.this.getViewportHeight(), FxCheckerboardWindow.this.getFieldHeight(), FxCheckerboardWindow.this.getFieldGap(), FxCheckerboardWindow.this._bordersV + FxCheckerboardWindow.this._windowDecorationV);
                    if (theNewFieldHeight == -1) break;
                    LOGGER.log(Level.FINE, "Field height changed to := " + theNewFieldHeight);
                    FxCheckerboardWindow.this.setFieldHeight(theNewFieldHeight);
                    break;
                }
            }
        }
    };
    private ChangeListener<Number> _onWindowWidthChangedEventHandler = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number aOldValue, Number aNewValue) {
            if (Double.isNaN(FxCheckerboardWindow.this._bordersH) && !Double.isNaN(aOldValue.doubleValue())) {
                FxCheckerboardWindow.this.initBordersH(aOldValue.doubleValue());
                FxCheckerboardWindow.this.initMinStageWidth();
            }
            switch (FxCheckerboardWindow.this.getScaleMode()) {
                case GRID: {
                    int theNewViewportWidth = FxCheckerboardWindow.this.toScaledViewportDimension(aNewValue.doubleValue(), FxCheckerboardWindow.this.getViewportWidth(), FxCheckerboardWindow.this.getFieldWidth(), FxCheckerboardWindow.this.getFieldGap(), FxCheckerboardWindow.this._bordersH + FxCheckerboardWindow.this._windowDecorationH);
                    if (theNewViewportWidth == -1) break;
                    LOGGER.log(Level.FINE, "Viewport width changed to := " + theNewViewportWidth);
                    FxCheckerboardWindow.this.setViewportWidth(theNewViewportWidth);
                    break;
                }
                case FIELDS: {
                    int theNewFieldWidth = FxCheckerboardWindow.this.toScaledFieldDimension(aNewValue.doubleValue(), FxCheckerboardWindow.this.getViewportWidth(), FxCheckerboardWindow.this.getFieldWidth(), FxCheckerboardWindow.this.getFieldGap(), FxCheckerboardWindow.this._bordersH + FxCheckerboardWindow.this._windowDecorationH);
                    if (theNewFieldWidth == -1) break;
                    LOGGER.log(Level.FINE, "Field width changed to := " + theNewFieldWidth);
                    FxCheckerboardWindow.this.setFieldWidth(theNewFieldWidth);
                    break;
                }
            }
        }
    };

    public FxCheckerboardWindow(Stage aStage, Scene aScene, Checkerboard<P, S> aCheckerboard) {
        super(aCheckerboard);
        this.widthProperty().addListener(this._onWindowWidthChangedEventHandler);
        this.heightProperty().addListener(this._onWindowHeightChangedEventHandler);
        this._stage = aStage;
        this._scene = aScene;
        this._stage.widthProperty().addListener(evt -> this.fxResizeStage());
        this._stage.heightProperty().addListener(evt -> this.fxResizeStage());
    }

    @Override
    public void onGridDimensionChangedEvent(GridDimensionChangedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.fxResizeGrid((GridDimension)aEvent, aEvent.getPrecedingGridDimension(), this._resizeGridMillis);
    }

    @Override
    public void onViewportDimensionChangedEvent(ViewportDimensionChangedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.fxResizeViewport((ViewportDimension)aEvent);
    }

    private synchronized void fxResizeGrid(final GridDimension aDimension, final GridDimension aPrecedingDimension, final int aDurationMillis) {
        Runnable theRunner = new Runnable(){

            @Override
            public void run() {
                if (FxCheckerboardWindow.this._backgroundFactory != null) {
                    FxCheckerboardWindow.this.fxUpdateBackground(aDimension, aPrecedingDimension, aDurationMillis);
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    private synchronized void fxResizeViewport(final ViewportDimension aDimension) {
        Runnable theRunner = new Runnable(){

            @Override
            public void run() {
                FxCheckerboardWindow.this.setFieldDimension((FieldDimension)FxCheckerboardWindow.this);
                FxCheckerboardWindow.this.setViewportDimension(aDimension);
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    private void fxResizeStage() {
        Runnable theRunner = new Runnable(){

            @Override
            public void run() {
                if (FxCheckerboardWindow.this._stage != null) {
                    switch (FxCheckerboardWindow.this.getScaleMode()) {
                        case GRID: 
                        case FIELDS: {
                            if (FxCheckerboardWindow.this._stage == null) break;
                            FxCheckerboardWindow.this._stage.setScene(FxCheckerboardWindow.this._scene);
                            break;
                        }
                        case NONE: {
                            if (FxCheckerboardWindow.this._stage == null) break;
                            FxCheckerboardWindow.this._stage.setScene(FxCheckerboardWindow.this._scene);
                            FxCheckerboardWindow.this._stage.sizeToScene();
                            FxCheckerboardWindow.this._stage.setResizable(false);
                        }
                    }
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    private void fxUpdateBackground(GridDimension aDimension, GridDimension aPrecedingDimension, int aDurationMillis) {
        int index = 0;
        final Node theOldBackgroundNode = this._backgroundNode;
        Node theNewBackgroundNode = (Node)this._backgroundFactory.createInstance((Object)this);
        FadeTransition theTransition = new FadeTransition(Duration.millis((double)aDurationMillis));
        if (theOldBackgroundNode != null) {
            index = this._checkers.getChildren().indexOf((Object)theOldBackgroundNode);
            theTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    FxCheckerboardWindow.this._checkers.getChildren().remove((Object)theOldBackgroundNode);
                }
            });
        }
        Node theTransitionNode = null;
        double theFromValue = 0.0;
        double theToValue = 1.0;
        if (aPrecedingDimension != null && aDimension.getGridWidth() >= aPrecedingDimension.getGridWidth() && aDimension.getGridHeight() >= aPrecedingDimension.getGridHeight()) {
            theTransitionNode = theNewBackgroundNode;
            theNewBackgroundNode.setOpacity(0.0);
            theFromValue = 0.0;
            theToValue = 1.0;
            ++index;
        } else if (aPrecedingDimension != null && aDimension.getGridWidth() <= aPrecedingDimension.getGridWidth() && aDimension.getGridHeight() <= aPrecedingDimension.getGridHeight()) {
            theTransitionNode = theOldBackgroundNode;
            theFromValue = 1.0;
            theToValue = 0.0;
        }
        if (aPrecedingDimension == null) {
            theTransitionNode = theNewBackgroundNode;
            theNewBackgroundNode.setOpacity(0.0);
        }
        this._backgroundNode = theNewBackgroundNode;
        this._checkers.getChildren().add(index, (Object)this._backgroundNode);
        theTransition.setNode(theTransitionNode);
        theTransition.setFromValue(theFromValue);
        theTransition.setToValue(theToValue);
        theTransition.setCycleCount(1);
        theTransition.setAutoReverse(false);
        theTransition.play();
    }
}

