/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard.alt.javafx;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.FadeTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.refcodes.checkerboard.ChangePositionEvent;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.CheckerboardEvent;
import org.refcodes.checkerboard.CheckerboardObserver;
import org.refcodes.checkerboard.CheckerboardViewer;
import org.refcodes.checkerboard.DraggabilityChangedEvent;
import org.refcodes.checkerboard.GraphicalCheckerboardViewer;
import org.refcodes.checkerboard.GridDimensionChangedEvent;
import org.refcodes.checkerboard.GridModeChangedEvent;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.PlayerAddedEvent;
import org.refcodes.checkerboard.PlayerEvent;
import org.refcodes.checkerboard.PlayerRemovedEvent;
import org.refcodes.checkerboard.PositionChangedEvent;
import org.refcodes.checkerboard.StateChangedEvent;
import org.refcodes.checkerboard.ViewportDimensionChangedEvent;
import org.refcodes.checkerboard.ViewportOffsetChangedEvent;
import org.refcodes.checkerboard.VisibilityChangedEvent;
import org.refcodes.checkerboard.alt.javafx.FxBackgroundFactory;
import org.refcodes.checkerboard.alt.javafx.FxSpriteFactory;
import org.refcodes.component.InitializeException;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.VetoException;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.FieldDimension;
import org.refcodes.graphical.GridDimension;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.MoveMode;
import org.refcodes.graphical.Offset;
import org.refcodes.graphical.Position;
import org.refcodes.graphical.ScaleMode;
import org.refcodes.graphical.ViewportDimension;
import org.refcodes.graphical.ViewportDimensionPropertyBuilder;
import org.refcodes.graphical.ViewportOffset;
import org.refcodes.graphical.ext.javafx.AbstractFxGridViewportPane;
import org.refcodes.mixin.Disposable;
import org.refcodes.observer.SubscribeEvent;
import org.refcodes.observer.UnsubscribeEvent;

public class FxCheckerboardViewer<P extends Player<P, S>, S>
extends AbstractFxGridViewportPane<FxCheckerboardViewer<P, S>>
implements GraphicalCheckerboardViewer<P, S, Node, FxSpriteFactory<S>, FxBackgroundFactory<P, S>, FxCheckerboardViewer<P, S>>,
CheckerboardObserver<P, S> {
    private static Logger LOGGER = Logger.getLogger(FxCheckerboardViewer.class.getName());
    private int _addPlayerDurationInMillis = 1000;
    private int _adjustPlayerDurationInMillis = 50;
    private Node _backgroundNode = null;
    private double _bordersH = Double.NaN;
    private double _bordersV = Double.NaN;
    private int _changePlayerStateInMillis = 300;
    private Checkerboard<P, S> _checkerboard;
    private Group _checkers = new Group();
    private int _initGridInMillis = 1500;
    private int _movePlayerDurationInMillis = 150;
    private Map<P, ClickPlayerEventHandler> _playerToClickEventHandler = new HashMap<P, ClickPlayerEventHandler>();
    private Map<P, DragPlayerEventHandler> _playerToDragEventHandler = new HashMap<P, DragPlayerEventHandler>();
    private Map<P, Node> _playerToSprite = new HashMap<P, Node>();
    private int _playerVisibilityDurationInMillis = 100;
    private int _removePlayerDurationInMillis = 1000;
    private int _resizeGridInMillis = 500;
    private double _windowDecorationH = Double.NaN;
    private double _windowDecorationV = Double.NaN;
    private ViewportDimensionPropertyBuilder _minViewportDimension = new ViewportDimensionPropertyBuilder(-1, -1);
    private ScaleMode _scaleMode = ScaleMode.GRID;
    private FxSpriteFactory<S> _spriteFactory = null;
    private FxBackgroundFactory<P, S> _backgroundFactory = null;
    private ChangeListener<Number> _onWindowHeightChangedEventHandler = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number aOldValue, Number aNewValue) {
            if (Double.isNaN(FxCheckerboardViewer.this._bordersV) && !Double.isNaN(aOldValue.doubleValue())) {
                FxCheckerboardViewer.this.initBordersV(aOldValue.doubleValue());
                FxCheckerboardViewer.this.initMinStageHeight();
            }
            switch (FxCheckerboardViewer.this.getScaleMode()) {
                case GRID: {
                    int theNewViewportHeight = FxCheckerboardViewer.this.toScaledViewportDimension(aNewValue.doubleValue(), FxCheckerboardViewer.this.getViewportHeight(), FxCheckerboardViewer.this.getFieldHeight(), FxCheckerboardViewer.this.getFieldGap(), FxCheckerboardViewer.this._bordersV + FxCheckerboardViewer.this._windowDecorationV);
                    if (theNewViewportHeight == -1) break;
                    LOGGER.log(Level.FINE, "Viewport height changed to := " + theNewViewportHeight);
                    FxCheckerboardViewer.this.setViewportHeight(theNewViewportHeight);
                    break;
                }
                case FIELDS: {
                    int theNewFieldHeight = FxCheckerboardViewer.this.toScaledFieldDimension(aNewValue.doubleValue(), FxCheckerboardViewer.this.getViewportHeight(), FxCheckerboardViewer.this.getFieldHeight(), FxCheckerboardViewer.this.getFieldGap(), FxCheckerboardViewer.this._bordersV + FxCheckerboardViewer.this._windowDecorationV);
                    if (theNewFieldHeight == -1) break;
                    LOGGER.log(Level.FINE, "Field height changed to := " + theNewFieldHeight);
                    FxCheckerboardViewer.this.setFieldHeight(theNewFieldHeight);
                    break;
                }
            }
        }
    };
    private ChangeListener<Number> _onWindowWidthChangedEventHandler = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number aOldValue, Number aNewValue) {
            if (Double.isNaN(FxCheckerboardViewer.this._bordersH) && !Double.isNaN(aOldValue.doubleValue())) {
                FxCheckerboardViewer.this.initBordersH(aOldValue.doubleValue());
                FxCheckerboardViewer.this.initMinStageWidth();
            }
            switch (FxCheckerboardViewer.this.getScaleMode()) {
                case GRID: {
                    int theNewViewportWidth = FxCheckerboardViewer.this.toScaledViewportDimension(aNewValue.doubleValue(), FxCheckerboardViewer.this.getViewportWidth(), FxCheckerboardViewer.this.getFieldWidth(), FxCheckerboardViewer.this.getFieldGap(), FxCheckerboardViewer.this._bordersH + FxCheckerboardViewer.this._windowDecorationH);
                    if (theNewViewportWidth == -1) break;
                    LOGGER.log(Level.FINE, "Viewport width changed to := " + theNewViewportWidth);
                    FxCheckerboardViewer.this.setViewportWidth(theNewViewportWidth);
                    break;
                }
                case FIELDS: {
                    int theNewFieldWidth = FxCheckerboardViewer.this.toScaledFieldDimension(aNewValue.doubleValue(), FxCheckerboardViewer.this.getViewportWidth(), FxCheckerboardViewer.this.getFieldWidth(), FxCheckerboardViewer.this.getFieldGap(), FxCheckerboardViewer.this._bordersH + FxCheckerboardViewer.this._windowDecorationH);
                    if (theNewFieldWidth == -1) break;
                    LOGGER.log(Level.FINE, "Field width changed to := " + theNewFieldWidth);
                    FxCheckerboardViewer.this.setFieldWidth(theNewFieldWidth);
                    break;
                }
            }
        }
    };

    public FxCheckerboardViewer(Checkerboard<P, S> aCheckerboard) {
        this._checkerboard = aCheckerboard;
        aCheckerboard.subscribeObserver((Object)this);
        this.widthProperty().addListener(this._onWindowWidthChangedEventHandler);
        this.heightProperty().addListener(this._onWindowHeightChangedEventHandler);
    }

    public void destroy() {
        this._checkerboard.destroy();
    }

    public int getAddPlayerDurationInMillis() {
        return this._addPlayerDurationInMillis;
    }

    public FxBackgroundFactory<P, S> getBackgroundFactory() {
        return this._backgroundFactory;
    }

    public int getChangePlayerStateInMillis() {
        return this._changePlayerStateInMillis;
    }

    public int getContainerHeight() {
        return this.getFieldHeight() * this.getViewportHeight() + this.getFieldGap() * (this.getViewportHeight() - 1) + (this._checkerboard.getGridMode() == GridMode.CLOSED ? this.getFieldGap() * 2 : 0);
    }

    public int getContainerWidth() {
        return this.getFieldWidth() * this.getViewportWidth() + this.getFieldGap() * (this.getViewportWidth() - 1) + (this._checkerboard.getGridMode() == GridMode.CLOSED ? this.getFieldGap() * 2 : 0);
    }

    public int getGridHeight() {
        return this._checkerboard.getGridHeight();
    }

    public GridMode getGridMode() {
        return this._checkerboard.getGridMode();
    }

    public int getGridWidth() {
        return this._checkerboard.getGridWidth();
    }

    public ViewportDimension getMinViewportDimension() {
        return this._minViewportDimension;
    }

    public int getMovePlayerDurationInMillis() {
        return this._movePlayerDurationInMillis;
    }

    public int getRemovePlayerDurationInMillis() {
        return this._removePlayerDurationInMillis;
    }

    public ScaleMode getScaleMode() {
        return this._scaleMode;
    }

    public FxSpriteFactory<S> getSpriteFactory() {
        return this._spriteFactory;
    }

    public synchronized void initialize() throws InitializeException {
        for (Player ePlayer : this._checkerboard.getPlayers()) {
            if (this._playerToSprite.containsKey(ePlayer)) continue;
            this.fxAddPlayer(ePlayer, this.getAddPlayerDurationInMillis());
        }
        if (Platform.isFxApplicationThread()) {
            this.fxInitialize();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        FxCheckerboardViewer.this.fxInitialize();
                    }
                    catch (InitializeException e) {
                        LOGGER.log(Level.SEVERE, "Exception during initialization: " + ExceptionUtility.toMessage((Throwable)e), e);
                    }
                }
            });
        }
    }

    public void onChangePositionEvent(ChangePositionEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) throws VetoException {
        LOGGER.log(Level.FINE, aEvent.toString());
    }

    public void onCheckerboardEvent(CheckerboardEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
    }

    public void onDraggabilityChangedEvent(DraggabilityChangedEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.fxPlayerDraggability(aEvent.getSource());
    }

    public void onGridDimensionChangedEvent(GridDimensionChangedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.fxResizeGrid((GridDimension)aEvent, aEvent.getPrecedingGridDimension(), this._resizeGridInMillis);
    }

    public void onGridModeChangedEvent(GridModeChangedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.setGridMode(aEvent.getGridMode());
        this.initMinStageWidth();
        this.initMinStageHeight();
    }

    public void onPlayerAddedEvent(PlayerAddedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.fxAddPlayer(aEvent.getPlayer(), this._addPlayerDurationInMillis);
    }

    public void onPlayerEvent(PlayerEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) {
        LOGGER.log(Level.FINE, aEvent.toString());
    }

    public void onPlayerRemovedEvent(PlayerRemovedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.fxRemovePlayer(aEvent.getPlayer(), this._removePlayerDurationInMillis);
    }

    public void onPositionChangedEvent(PositionChangedEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.fxMovePlayer(aEvent.getSource(), aEvent.getPrecedingPosition(), this._movePlayerDurationInMillis);
    }

    public void onStateChangedEvent(StateChangedEvent<P, S> aEvent, Checkerboard<P, S> aCheckerboard) {
        LOGGER.log(Level.FINE, aEvent.toString());
        Node theSprite = this._spriteFactory.createInstance(aEvent.getSource().getStatus(), this);
        Node prevSprite = this._playerToSprite.get(aEvent.getSource());
        if (theSprite != prevSprite) {
            this.fxRemovePlayer(aEvent.getSource(), this._changePlayerStateInMillis / 2);
            this.fxAddPlayer(aEvent.getSource(), this._changePlayerStateInMillis / 2);
        }
    }

    public void onSubscribe(SubscribeEvent<Checkerboard<P, S>> aSubscribeEvent) {
        this._checkerboard = (Checkerboard)aSubscribeEvent.getSource();
    }

    public void onUnsubscribe(UnsubscribeEvent<Checkerboard<P, S>> aUnsubscribeEvent) {
        if (this._checkerboard == aUnsubscribeEvent.getSource()) {
            this._checkerboard = null;
        }
    }

    public void onViewportDimensionChangedEvent(ViewportDimensionChangedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.fxResizeViewport((ViewportDimension)aEvent, aEvent.getPrecedingViewportDimension(), aEvent.getViewportOffset(), this._resizeGridInMillis);
    }

    public void onViewportOffsetChangedEvent(ViewportOffsetChangedEvent<P, S> aEvent) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.setViewportOffset((ViewportOffset)this);
    }

    public void onVisibilityChangedEvent(VisibilityChangedEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) {
        LOGGER.log(Level.FINE, aEvent.toString());
        this.fxPlayerVisibility(aEvent.getSource(), this._playerVisibilityDurationInMillis);
    }

    public void setAddPlayerDurationInMillis(int aAddPlayerDurationInMillis) {
        this._addPlayerDurationInMillis = aAddPlayerDurationInMillis;
    }

    public void setBackgroundFactory(FxBackgroundFactory<P, S> aBackgroundFactory) {
        this._backgroundFactory = aBackgroundFactory;
    }

    public void setChangePlayerStateInMillis(int aChangePlayerStateInMillis) {
        this._changePlayerStateInMillis = aChangePlayerStateInMillis;
    }

    public void setFieldDimension(Dimension aDimension) {
        this.setFieldDimension(aDimension.getWidth(), aDimension.getHeight());
    }

    public void setFieldDimension(FieldDimension aField) {
        this.setFieldDimension(aField.getFieldWidth(), aField.getFieldHeight());
    }

    public void setMinViewportDimension(Dimension aDimension) {
        this._minViewportDimension.setViewportDimension(aDimension);
    }

    public void setMinViewportDimension(int aWidth, int aHeight) {
        this._minViewportDimension.setViewportDimension(aWidth, aHeight);
    }

    public void setMinViewportDimension(ViewportDimension aDimension) {
        this._minViewportDimension.setViewportDimension(aDimension);
    }

    public void setMovePlayerDurationInMillis(int aMovePlayerDurationInMillis) {
        this._movePlayerDurationInMillis = aMovePlayerDurationInMillis;
    }

    public void setRemovePlayerDurationInMillis(int aRemovePlayerDurationInMillis) {
        this._removePlayerDurationInMillis = aRemovePlayerDurationInMillis;
    }

    public void setScaleMode(ScaleMode aMode) {
        this._scaleMode = aMode;
    }

    public void setSpriteFactory(FxSpriteFactory<S> aSpriteFactory) {
        this._spriteFactory = aSpriteFactory;
    }

    public void setViewportDimension(Dimension aDimension) {
        this.setViewportDimension(aDimension.getWidth(), aDimension.getHeight());
    }

    public void setViewportOffset(int aPosX, int aPosY) {
        if (aPosX != this.getViewportOffsetX() || aPosY != this.getViewportOffsetY()) {
            ViewportOffsetChangedEvent theEvent = new ViewportOffsetChangedEvent(aPosX, aPosY, this.getViewportOffsetX(), this.getViewportOffsetY(), (CheckerboardViewer)this);
            super.setViewportOffset(aPosX, aPosY);
            this.onViewportOffsetChangedEvent(theEvent);
        }
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public int toTotalHeight() {
        int theTotalHeight = this.getFieldHeight() * this.getViewportHeight() + this.getFieldGap() * (this.getViewportHeight() - 1);
        if (this.getGridMode() == GridMode.CLOSED) {
            theTotalHeight += this.getFieldGap() * 2;
        }
        return theTotalHeight;
    }

    public int toTotalWidth() {
        int theTotalWidth = this.getFieldWidth() * this.getViewportWidth() + this.getFieldGap() * (this.getViewportWidth() - 1);
        if (this.getGridMode() == GridMode.CLOSED) {
            theTotalWidth += this.getFieldGap() * 2;
        }
        return theTotalWidth;
    }

    public FxCheckerboardViewer<P, S> withAddPlayerDurationInMillis(int aAddPlayerDurationInMillis) {
        this.setAddPlayerDurationInMillis(aAddPlayerDurationInMillis);
        return this;
    }

    public FxCheckerboardViewer<P, S> withBackgroundFactory(FxBackgroundFactory<P, S> aBackgroundFactory) {
        this.setBackgroundFactory(aBackgroundFactory);
        return this;
    }

    public FxCheckerboardViewer<P, S> withChangePlayerStateInMillis(int aChangePlayerStateInMillis) {
        this.setChangePlayerStateInMillis(aChangePlayerStateInMillis);
        return this;
    }

    public FxCheckerboardViewer<P, S> withContent(Node aContent) {
        this.setContent(aContent);
        return this;
    }

    public FxCheckerboardViewer<P, S> withDragOpacity(double aOpacity) {
        this.setDragOpacity(aOpacity);
        return this;
    }

    public FxCheckerboardViewer<P, S> withFieldDimension(Dimension aDimension) {
        this.setFieldDimension(aDimension);
        return this;
    }

    public FxCheckerboardViewer<P, S> withFieldDimension(FieldDimension aField) {
        this.setFieldDimension(aField);
        return this;
    }

    public FxCheckerboardViewer<P, S> withFieldDimension(int aFieldWidth, int aFieldHeight) {
        this.setFieldDimension(aFieldWidth, aFieldHeight);
        return this;
    }

    public FxCheckerboardViewer<P, S> withFieldDimension(int aFieldWidth, int aFieldHeight, int aGap) {
        this.setFieldDimension(aFieldWidth, aFieldHeight, aGap);
        return this;
    }

    public FxCheckerboardViewer<P, S> withFieldGap(int aFieldGap) {
        this.setFieldGap(aFieldGap);
        return this;
    }

    public FxCheckerboardViewer<P, S> withFieldHeight(int aHeight) {
        this.setFieldHeight(aHeight);
        return this;
    }

    public FxCheckerboardViewer<P, S> withFieldWidth(int aWidth) {
        this.setFieldWidth(aWidth);
        return this;
    }

    public FxCheckerboardViewer<P, S> withGridMode(GridMode aGridMode) {
        this.setGridMode(aGridMode);
        return this;
    }

    public FxCheckerboardViewer<P, S> withHide() {
        this.hide();
        return this;
    }

    public FxCheckerboardViewer<P, S> withInitialize() throws InitializeException {
        this.initialize();
        return this;
    }

    public FxCheckerboardViewer<P, S> withMinViewportDimension(Dimension aDimension) {
        this.setMinViewportDimension(aDimension);
        return this;
    }

    public FxCheckerboardViewer<P, S> withMinViewportDimension(int aWidth, int aHeight) {
        this.setMinViewportDimension(aWidth, aHeight);
        return this;
    }

    public FxCheckerboardViewer<P, S> withMinViewportDimension(ViewportDimension aDimension) {
        this.setMinViewportDimension(aDimension);
        return this;
    }

    public FxCheckerboardViewer<P, S> withMoveMode(MoveMode aMode) {
        this.setMoveMode(aMode);
        return this;
    }

    public FxCheckerboardViewer<P, S> withMovePlayerDurationInMillis(int aMovePlayerDurationInMillis) {
        this.setMovePlayerDurationInMillis(aMovePlayerDurationInMillis);
        return this;
    }

    public FxCheckerboardViewer<P, S> withRemovePlayerDurationInMillis(int aRemovePlayerDurationInMillis) {
        this.setRemovePlayerDurationInMillis(aRemovePlayerDurationInMillis);
        return this;
    }

    public FxCheckerboardViewer<P, S> withScaleMode(ScaleMode aMode) {
        this.setScaleMode(aMode);
        return this;
    }

    public FxCheckerboardViewer<P, S> withShow() {
        this.show();
        return this;
    }

    public FxCheckerboardViewer<P, S> withSpriteFactory(FxSpriteFactory<S> aSpriteFactory) {
        this.setSpriteFactory(aSpriteFactory);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportDimension(Dimension aDimension) {
        this.setViewportDimension(aDimension);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportDimension(int aWidth, int aHeight) {
        this.setViewportDimension(aWidth, aHeight);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportDimension(ViewportDimension aGridDimension) {
        this.setViewportDimension(aGridDimension);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportHeight(int aGridHeight) {
        this.setViewportHeight(aGridHeight);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportOffset(int aPosX, int aPosY) {
        this.setViewportOffset(aPosX, aPosY);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportOffset(Offset aOffset) {
        this.setViewportOffset(aOffset);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportOffset(Position aOffset) {
        this.setViewportOffset(aOffset);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportOffset(ViewportOffset aOffset) {
        this.setViewportOffset(aOffset);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportOffsetX(int aPosX) {
        this.setViewportOffsetX(aPosX);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportOffsetY(int aPosY) {
        this.setViewportOffsetY(aPosY);
        return this;
    }

    public FxCheckerboardViewer<P, S> withViewportWidth(int aGridWidth) {
        this.setViewportWidth(aGridWidth);
        return this;
    }

    public FxCheckerboardViewer<P, S> withVisible(boolean isVisible) {
        this.setVisible(isVisible);
        return this;
    }

    public String toString() {
        return this._checkerboard.toString();
    }

    protected void hidePlayers(int aDurationInMillis) {
        for (Player ePlayer : this._checkerboard.getPlayers()) {
            this.fxHidePlayer(ePlayer, aDurationInMillis);
        }
    }

    protected void resetPlayers(int aDurationInMillis) {
        for (Player ePlayer : this._checkerboard.getPlayers()) {
            this.fxResetPlayer(ePlayer, aDurationInMillis);
        }
    }

    protected void scalePlayers(FieldDimension aFieldDimension, FieldDimension aPrecedingFieldDimension) {
        for (Player ePlayer : this._checkerboard.getPlayers()) {
            this.fxScalePlayer(ePlayer, aFieldDimension, aPrecedingFieldDimension);
        }
    }

    private void fxAddPlayer(P aPlayer, int aDurationInMillis) {
        Node theSprite = this._spriteFactory.createInstance(aPlayer.getStatus(), this);
        this.fxAddPlayer(aPlayer, aDurationInMillis, theSprite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxAddPlayer(P aPlayer, int aDurationInMillis, Node aSprite) {
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            this._playerToSprite.put(aPlayer, aSprite);
        }
        if (aPlayer.isDraggable()) {
            DragPlayerEventHandler theDragEventHandler = new DragPlayerEventHandler(this, aPlayer, aSprite);
            this._playerToDragEventHandler.put(aPlayer, theDragEventHandler);
        }
        ClickPlayerEventHandler theClickEventHandler = new ClickPlayerEventHandler(this, aPlayer, aSprite);
        this._playerToClickEventHandler.put(aPlayer, theClickEventHandler);
        Point2D thePoint = aSprite.localToParent(0.0, 0.0);
        aSprite.setLayoutX(-thePoint.getX());
        aSprite.setLayoutY(-thePoint.getY());
        aSprite.setTranslateX((double)this.toPixelPositionX((Position)aPlayer));
        aSprite.setTranslateY((double)this.toPixelPositionY((Position)aPlayer));
        Runnable theRunner = new Runnable(){
            final /* synthetic */ Player val$aPlayer;
            final /* synthetic */ Node val$aSprite;
            final /* synthetic */ int val$aDurationInMillis;
            {
                this.val$aPlayer = player;
                this.val$aSprite = node;
                this.val$aDurationInMillis = n;
            }

            @Override
            public void run() {
                if (FxCheckerboardViewer.this.isViewport((Position)this.val$aPlayer)) {
                    FxCheckerboardViewer.this._checkers.getChildren().add((Object)this.val$aSprite);
                    if (this.val$aPlayer.isVisible()) {
                        if (this.val$aDurationInMillis > 0) {
                            this.val$aSprite.setOpacity(0.0);
                            FadeTransition theTransition = new FadeTransition(Duration.millis((double)this.val$aDurationInMillis), this.val$aSprite);
                            theTransition.setFromValue(0.0);
                            theTransition.setToValue(1.0);
                            theTransition.setCycleCount(1);
                            theTransition.setAutoReverse(false);
                            theTransition.play();
                        } else {
                            this.val$aSprite.setOpacity(1.0);
                            this.val$aSprite.setVisible(true);
                        }
                    }
                } else {
                    this.val$aSprite.setVisible(true);
                    FxCheckerboardViewer.this._checkers.getChildren().add((Object)this.val$aSprite);
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxHidePlayer(P aPlayer, final int aDurationInMillis) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        if (theSprite != null) {
            if (aDurationInMillis == 0) {
                theSprite.setOpacity(0.0);
            } else if (theSprite.getOpacity() != 0.0) {
                Runnable theRunner = new Runnable(){

                    @Override
                    public void run() {
                        FadeTransition theTransition = new FadeTransition(Duration.millis((double)aDurationInMillis), theSprite);
                        theTransition.setFromValue(theSprite.getOpacity());
                        theTransition.setToValue(0.0);
                        theTransition.setCycleCount(1);
                        theTransition.setAutoReverse(false);
                        theTransition.play();
                    }
                };
                if (Platform.isFxApplicationThread()) {
                    theRunner.run();
                } else {
                    Platform.runLater((Runnable)theRunner);
                }
            }
        }
    }

    private void fxInitialize() throws InitializeException {
        try {
            LOGGER.log(Level.FINE, "Initializing ...");
            if (this.getViewportWidth() == -1) {
                this.setViewportWidth(this.getGridWidth());
            }
            if (this.getViewportHeight() == -1) {
                this.setViewportHeight(this.getGridHeight());
            }
            if (this.getViewportWidth() == -1 || this.getViewportHeight() == -1) {
                throw new IllegalStateException("The viewport dimension for the checkerboard must be set!");
            }
            this.fxResizeViewport((ViewportDimension)this, null, (ViewportOffset)this, this._initGridInMillis);
            this.fxResizeGrid((GridDimension)this, null, this._initGridInMillis);
            switch (this.getScaleMode()) {
                case NONE: {
                    StackPane thePane = new StackPane();
                    thePane.getChildren().add((Object)this._checkers);
                    StackPane.setAlignment((Node)this._checkers, (Pos)Pos.CENTER);
                    this.setContent((Node)thePane);
                    break;
                }
                case GRID: 
                case FIELDS: {
                    this.setContent((Node)this._checkers);
                    this.setViewportOffset((ViewportOffset)this);
                    this.setFieldDimension((FieldDimension)this);
                }
            }
        }
        catch (Exception e) {
            throw new InitializeException("Exception during initialization: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxMovePlayer(P aPlayer, Position aPrecedingPosition, final int aDurationInMillis) {
        Node theSprite;
        FxCheckerboardViewer fxCheckerboardViewer = this;
        synchronized (fxCheckerboardViewer) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        Runnable theRunner = new Runnable(){
            final /* synthetic */ Player val$aPlayer;
            {
                this.val$aPlayer = player;
            }

            @Override
            public void run() {
                if (FxCheckerboardViewer.this._checkers.getChildren().remove((Object)theSprite)) {
                    FxCheckerboardViewer.this._checkers.getChildren().add((Object)theSprite);
                    if (FxCheckerboardViewer.this.getMoveMode() == MoveMode.SMOOTH) {
                        TranslateTransition theTransition = new TranslateTransition(Duration.millis((double)aDurationInMillis), theSprite);
                        theTransition.setByX((double)FxCheckerboardViewer.this.toPixelPositionX((Position)this.val$aPlayer) - theSprite.getTranslateX());
                        theTransition.setByY((double)FxCheckerboardViewer.this.toPixelPositionY((Position)this.val$aPlayer) - theSprite.getTranslateY());
                        theTransition.setCycleCount(1);
                        theTransition.setAutoReverse(false);
                        theTransition.play();
                    } else {
                        theSprite.setTranslateX((double)FxCheckerboardViewer.this.toPixelPositionX((Position)this.val$aPlayer));
                        theSprite.setTranslateY((double)FxCheckerboardViewer.this.toPixelPositionY((Position)this.val$aPlayer));
                    }
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxPlayerDraggability(P aPlayer) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        if (theSprite != null) {
            if (aPlayer.isDraggable() && !this._playerToDragEventHandler.containsKey(aPlayer)) {
                theDragEventHandler = new DragPlayerEventHandler(this, aPlayer, theSprite);
                this._playerToDragEventHandler.put(aPlayer, theDragEventHandler);
            } else {
                theDragEventHandler = this._playerToDragEventHandler.remove(aPlayer);
                if (theDragEventHandler != null) {
                    theDragEventHandler.dispose();
                }
            }
        } else {
            throw new IllegalStateException("The player <" + aPlayer + "> is unknwon by this checkerboard.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxPlayerVisibility(P aPlayer, int aDurationInMillis) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        if (theSprite != null) {
            FadeTransition theTransition = new FadeTransition(Duration.millis((double)aDurationInMillis), theSprite);
            theTransition.setFromValue(aPlayer.isVisible() ? 0.0 : 1.0);
            theTransition.setToValue(aPlayer.isVisible() ? 1.0 : 0.0);
            theTransition.setCycleCount(1);
            theTransition.setAutoReverse(false);
            theTransition.play();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxRemovePlayer(P aPlayer, int aDurationInMillis) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.remove(aPlayer);
        }
        this.fxRemovePlayer(aPlayer, theSprite, aDurationInMillis);
    }

    private void fxRemovePlayer(P aPlayer, final Node aSprite, int aDurationInMillis) {
        ClickPlayerEventHandler theClickEventHandler;
        DragPlayerEventHandler theDragEventHandler = this._playerToDragEventHandler.remove(aPlayer);
        if (theDragEventHandler != null) {
            theDragEventHandler.dispose();
        }
        if ((theClickEventHandler = this._playerToClickEventHandler.remove(aPlayer)) != null) {
            theClickEventHandler.dispose();
        }
        if (aSprite != null) {
            FadeTransition theTransition = new FadeTransition(Duration.millis((double)aDurationInMillis), aSprite);
            theTransition.setFromValue(1.0);
            theTransition.setToValue(0.0);
            theTransition.setCycleCount(1);
            theTransition.setAutoReverse(false);
            theTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    FxCheckerboardViewer.this._checkers.getChildren().remove((Object)aSprite);
                }
            });
            theTransition.play();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxResetPlayer(P aPlayer, int aDurationInMillis) {
        Node thePrevSprite;
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._spriteFactory.createInstance(aPlayer.getStatus(), this);
            thePrevSprite = this._playerToSprite.put(aPlayer, theSprite);
        }
        if (aPlayer.isDraggable()) {
            DragPlayerEventHandler theDragEventHandler = new DragPlayerEventHandler(this, aPlayer, theSprite);
            this._playerToDragEventHandler.put(aPlayer, theDragEventHandler);
        }
        ClickPlayerEventHandler theClickEventHandler = new ClickPlayerEventHandler(this, aPlayer, theSprite);
        this._playerToClickEventHandler.put(aPlayer, theClickEventHandler);
        theSprite.setOpacity(0.0);
        Point2D thePoint = theSprite.localToParent(0.0, 0.0);
        theSprite.setLayoutX(-thePoint.getX());
        theSprite.setLayoutY(-thePoint.getY());
        theSprite.setTranslateX((double)this.toPixelPositionX((Position)aPlayer));
        theSprite.setTranslateY((double)this.toPixelPositionY((Position)aPlayer));
        this._checkers.getChildren().add((Object)theSprite);
        if (thePrevSprite != null) {
            this._checkers.getChildren().remove((Object)thePrevSprite);
        }
        Runnable theRunner = new Runnable(){
            final /* synthetic */ Player val$aPlayer;
            final /* synthetic */ Node val$theSprite;
            final /* synthetic */ int val$aDurationInMillis;
            {
                this.val$aPlayer = player;
                this.val$theSprite = node;
                this.val$aDurationInMillis = n;
            }

            @Override
            public void run() {
                if (this.val$aPlayer.isVisible() && this.val$theSprite.getOpacity() == 0.0) {
                    FadeTransition theTransition = new FadeTransition(Duration.millis((double)this.val$aDurationInMillis), this.val$theSprite);
                    theTransition.setFromValue(0.0);
                    theTransition.setToValue(1.0);
                    theTransition.setCycleCount(1);
                    theTransition.setAutoReverse(false);
                    theTransition.play();
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    private synchronized void fxResizeGrid(final GridDimension aDimension, final GridDimension aPrecedingDimension, final int aDurationInMillis) {
        Runnable theRunner = new Runnable(){

            @Override
            public void run() {
                if (FxCheckerboardViewer.this._backgroundFactory != null) {
                    FxCheckerboardViewer.this.fxUpdateBackground(aDimension, aPrecedingDimension, aDurationInMillis);
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    private synchronized void fxResizeViewport(final ViewportDimension aDimension, ViewportDimension aPrecedingDimension, ViewportOffset aOffset, int aDurationInMillis) {
        Runnable theRunner = new Runnable(){

            @Override
            public void run() {
                FxCheckerboardViewer.this.setFieldDimension((FieldDimension)FxCheckerboardViewer.this);
                FxCheckerboardViewer.this.setViewportDimension(aDimension);
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxScalePlayer(P aPlayer, FieldDimension aFieldDimension, FieldDimension aPrecedingFieldDimension) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        theSprite.setScaleX((double)aFieldDimension.getFieldWidth() / theSprite.getBoundsInLocal().getWidth());
        theSprite.setScaleY((double)aFieldDimension.getFieldHeight() / theSprite.getBoundsInLocal().getHeight());
        double theLayoutX = ((double)aFieldDimension.getFieldWidth() - theSprite.getBoundsInLocal().getWidth()) / 2.0;
        double theLayoutY = ((double)aFieldDimension.getFieldHeight() - theSprite.getBoundsInLocal().getHeight()) / 2.0;
        theSprite.setLayoutX(theLayoutX);
        theSprite.setLayoutY(theLayoutY);
        theSprite.setTranslateX((double)this.toPixelPositionX((Position)aPlayer));
        theSprite.setTranslateY((double)this.toPixelPositionY((Position)aPlayer));
    }

    private void fxUpdateBackground(GridDimension aDimension, GridDimension aPrecedingDimension, int aDurationInMillis) {
        int index = 0;
        final Node theOldBackgroundNode = this._backgroundNode;
        Node theNewBackgroundNode = (Node)this._backgroundFactory.createInstance((Object)this);
        FadeTransition theTransition = new FadeTransition(Duration.millis((double)aDurationInMillis));
        if (theOldBackgroundNode != null) {
            index = this._checkers.getChildren().indexOf((Object)theOldBackgroundNode);
            theTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    FxCheckerboardViewer.this._checkers.getChildren().remove((Object)theOldBackgroundNode);
                }
            });
        }
        Node theTransitionNode = null;
        double theFromValue = 0.0;
        double theToValue = 1.0;
        if (aPrecedingDimension != null && aDimension.getGridWidth() >= aPrecedingDimension.getGridWidth() && aDimension.getGridHeight() >= aPrecedingDimension.getGridHeight()) {
            theTransitionNode = theNewBackgroundNode;
            theNewBackgroundNode.setOpacity(0.0);
            theFromValue = 0.0;
            theToValue = 1.0;
            ++index;
        } else if (aPrecedingDimension != null && aDimension.getGridWidth() <= aPrecedingDimension.getGridWidth() && aDimension.getGridHeight() <= aPrecedingDimension.getGridHeight()) {
            theTransitionNode = theOldBackgroundNode;
            theFromValue = 1.0;
            theToValue = 0.0;
        }
        if (aPrecedingDimension == null) {
            theTransitionNode = theNewBackgroundNode;
            theNewBackgroundNode.setOpacity(0.0);
        }
        this._backgroundNode = theNewBackgroundNode;
        this._checkers.getChildren().add(index, (Object)this._backgroundNode);
        theTransition.setNode(theTransitionNode);
        theTransition.setFromValue(theFromValue);
        theTransition.setToValue(theToValue);
        theTransition.setCycleCount(1);
        theTransition.setAutoReverse(false);
        theTransition.play();
    }

    private void initBordersH(double aWindowWidth) {
        if (Double.isNaN(this._bordersH)) {
            double theBoardersH = aWindowWidth - (double)((this.getViewportWidth() - 1) * this.getFieldGap());
            if (this._checkerboard.getGridMode() == GridMode.CLOSED) {
                theBoardersH -= (double)(this.getFieldGap() * 2);
            }
            theBoardersH -= (double)(this.getViewportWidth() * this.getFieldWidth());
            theBoardersH = this._checkerboard.getGridMode() == GridMode.CLOSED ? (theBoardersH += (double)this.getFieldGap()) : (theBoardersH -= (double)this.getFieldGap());
            LOGGER.log(Level.FINE, "Horizontal (left and right) [phantom] borders from width <" + aWindowWidth + "> := " + theBoardersH);
            this._bordersH = theBoardersH;
        }
    }

    private void initBordersV(double aWindowHeight) {
        if (Double.isNaN(this._bordersV)) {
            double theBoardersV = aWindowHeight - (double)((this.getViewportHeight() - 1) * this.getFieldGap());
            if (this._checkerboard.getGridMode() == GridMode.CLOSED) {
                theBoardersV -= (double)(this.getFieldGap() * 2);
            }
            theBoardersV -= (double)(this.getViewportHeight() * this.getFieldHeight());
            theBoardersV = this._checkerboard.getGridMode() == GridMode.CLOSED ? (theBoardersV += (double)this.getFieldGap()) : (theBoardersV -= (double)this.getFieldGap());
            LOGGER.log(Level.FINE, "Vertical (top and bottom) [phantom] borders from height <" + aWindowHeight + "> := " + theBoardersV);
            this._bordersV = theBoardersV;
        }
    }

    private void initMinStageHeight() {
        if (Double.isNaN(this._bordersV)) {
            this.initBordersV(this.getHeight());
        } else {
            int theHeight = (int)this._bordersV;
            this.setMinHeight((double)(theHeight += this.getViewportHeight() * this.getFieldHeight() + this.getViewportHeight() * this.getFieldGap()) + this._windowDecorationV);
        }
    }

    private void initMinStageWidth() {
        if (Double.isNaN(this._bordersH)) {
            this.initBordersH(this.getWidth());
        } else {
            int theWidth = (int)this._bordersH;
            this.setMinWidth((double)(theWidth += this.getViewportWidth() * this.getFieldWidth() + this.getViewportWidth() * this.getFieldGap()) + this._windowDecorationH);
        }
    }

    private boolean isViewport(Position aPosition) {
        return this.isViewportPosX(aPosition.getPositionX()) && this.isViewportPosY(aPosition.getPositionY());
    }

    private boolean isViewportPosX(int aPositionX) {
        return aPositionX >= this.getViewportOffsetX() && aPositionX < this.getViewportWidth() + this.getViewportOffsetX();
    }

    private boolean isViewportPosY(int aPositionY) {
        return aPositionY >= this.getViewportOffsetY() && aPositionY < this.getViewportHeight() + this.getViewportOffsetY();
    }

    private int toPixelPositionX(Position aPosition) {
        return (this.getFieldWidth() + this.getFieldGap()) * aPosition.getPositionX() + (this.getGridMode() == GridMode.CLOSED ? this.getFieldGap() : 0);
    }

    private int toPixelPositionY(Position aPosition) {
        return (this.getFieldHeight() + this.getFieldGap()) * aPosition.getPositionY() + (this.getGridMode() == GridMode.CLOSED ? this.getFieldGap() : 0);
    }

    private int toScaledFieldDimension(double aNewWindowDim, int aViewportDim, int aFieldDim, int aFieldGap, double aBordersDim) {
        if (!Double.isNaN(aBordersDim) && aNewWindowDim != 1.0) {
            double theCheckerboardDim = aNewWindowDim - aBordersDim;
            int theFieldDim = (int)Math.round(((theCheckerboardDim -= (double)aFieldGap) - (double)((aViewportDim - 1) * aFieldGap)) / (double)aViewportDim);
            if (theFieldDim != aFieldDim) {
                try {
                    return theFieldDim;
                }
                catch (VetoException.VetoRuntimeException vetoRuntimeException) {
                    // empty catch block
                }
            }
        }
        return -1;
    }

    private int toScaledViewportDimension(double aNewWindowDim, int aViewportDim, int aFieldDim, int aFieldGap, double aBordersDim) {
        if (!Double.isNaN(aBordersDim) && aNewWindowDim != 1.0) {
            double theCheckerboardDim = aNewWindowDim - aBordersDim;
            int theViewportDim = (int)Math.round((theCheckerboardDim -= (double)aFieldGap) / (double)(aFieldDim + aFieldGap));
            if (theViewportDim != aViewportDim) {
                try {
                    return theViewportDim;
                }
                catch (VetoException.VetoRuntimeException vetoRuntimeException) {
                    // empty catch block
                }
            }
        }
        return -1;
    }

    private static class DragPlayerEventHandler
    implements Disposable {
        private P _player;
        private double _sceneX;
        private double _sceneY;
        private Node _sprite;
        private double _translateX;
        private double _translateY;
        private EventHandler<MouseEvent> _onMouseDraggedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent aEvent) {
                if (DragPlayerEventHandler.this._player.isVisible()) {
                    Node theSprite = (Node)aEvent.getSource();
                    double theSceneOffsetX = aEvent.getSceneX() - DragPlayerEventHandler.this._sceneX;
                    double theSceneOffsetY = aEvent.getSceneY() - DragPlayerEventHandler.this._sceneY;
                    double theTranslateX = DragPlayerEventHandler.this._translateX + theSceneOffsetX;
                    double theTranslateY = DragPlayerEventHandler.this._translateY + theSceneOffsetY;
                    int theBorderWidth = (int)DragPlayerEventHandler.this.this$0._bordersH / 2;
                    int theBorderHeight = (int)DragPlayerEventHandler.this.this$0._bordersV / 2;
                    if (theTranslateX >= (double)(-theBorderWidth) && theTranslateX <= (double)((DragPlayerEventHandler.this.this$0.getFieldWidth() + DragPlayerEventHandler.this.this$0.getFieldGap()) * (DragPlayerEventHandler.this.this$0.getGridWidth() - 1) + theBorderWidth)) {
                        theSprite.setTranslateX(theTranslateX);
                    }
                    if (theTranslateY >= (double)(-theBorderHeight) && theTranslateY <= (double)((DragPlayerEventHandler.this.this$0.getFieldHeight() + DragPlayerEventHandler.this.this$0.getFieldGap()) * (DragPlayerEventHandler.this.this$0.getGridHeight() - 1) + theBorderHeight)) {
                        theSprite.setTranslateY(theTranslateY);
                    }
                    aEvent.consume();
                }
            }
        };
        private EventHandler<MouseEvent> _onMousePressedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent aEvent) {
                if (DragPlayerEventHandler.this._player.isVisible()) {
                    Node theSprite = (Node)aEvent.getSource();
                    theSprite.setOpacity(0.5);
                    DragPlayerEventHandler.this._sceneX = aEvent.getSceneX();
                    DragPlayerEventHandler.this._sceneY = aEvent.getSceneY();
                    DragPlayerEventHandler.this._translateX = theSprite.getTranslateX();
                    DragPlayerEventHandler.this._translateY = theSprite.getTranslateY();
                    LOGGER.log(Level.FINE, "Player mouse press X := " + aEvent.getSceneX());
                    LOGGER.log(Level.FINE, "Player mouse press Y := " + aEvent.getSceneY());
                    aEvent.consume();
                }
            }
        };
        private EventHandler<MouseEvent> _onMouseReleasedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent aEvent) {
                Node theSprite = (Node)aEvent.getSource();
                if (DragPlayerEventHandler.this._player.isVisible()) {
                    double theSceneOffsetX = aEvent.getSceneX() - DragPlayerEventHandler.this._sceneX;
                    double theSceneOffsetY = aEvent.getSceneY() - DragPlayerEventHandler.this._sceneY;
                    double theStepX = Math.round(theSceneOffsetX / (double)(DragPlayerEventHandler.this.this$0.getFieldWidth() + DragPlayerEventHandler.this.this$0.getFieldGap()));
                    double theStepY = Math.round(theSceneOffsetY / (double)(DragPlayerEventHandler.this.this$0.getFieldHeight() + DragPlayerEventHandler.this.this$0.getFieldGap()));
                    int thePosX = (int)((double)DragPlayerEventHandler.this._player.getPositionX() + theStepX);
                    int thePosY = (int)((double)DragPlayerEventHandler.this._player.getPositionY() + theStepY);
                    if (thePosX >= DragPlayerEventHandler.this.this$0.getGridWidth() || thePosX < 0 || thePosY >= DragPlayerEventHandler.this.this$0.getGridHeight() || thePosY < 0) {
                        theStepY = 0.0;
                        theStepX = 0.0;
                        thePosY = (int)((double)DragPlayerEventHandler.this._player.getPositionY() + theStepY);
                        thePosX = (int)((double)DragPlayerEventHandler.this._player.getPositionX() + theStepX);
                    }
                    try {
                        DragPlayerEventHandler.this._player.setPosition(thePosX, thePosY);
                    }
                    catch (VetoException.VetoRuntimeException e) {
                        LOGGER.log(Level.WARNING, "Change player <" + DragPlayerEventHandler.this._player + "> position to (" + thePosX + ", " + thePosY + ") has been vetoed: " + ExceptionUtility.toMessage((Throwable)e), e);
                        theStepX = 0.0;
                        theStepY = 0.0;
                    }
                    if (theStepX == 0.0 && theStepY == 0.0) {
                        DragPlayerEventHandler.this.this$0.fxMovePlayer(DragPlayerEventHandler.this._player, (Position)DragPlayerEventHandler.this._player, DragPlayerEventHandler.this.this$0._adjustPlayerDurationInMillis);
                    }
                    theSprite.setOpacity(1.0);
                    aEvent.consume();
                }
            }
        };
        final /* synthetic */ FxCheckerboardViewer this$0;

        public DragPlayerEventHandler(P aPlayer, Node aSprite) {
            this.this$0 = var1_1;
            aSprite.setOnMousePressed(this._onMousePressedEventHandler);
            aSprite.setOnMouseDragged(this._onMouseDraggedEventHandler);
            aSprite.setOnMouseReleased(this._onMouseReleasedEventHandler);
            this._player = aPlayer;
            this._sprite = aSprite;
        }

        public void dispose() {
            this._sprite.removeEventHandler(MouseEvent.MOUSE_PRESSED, this._onMousePressedEventHandler);
            this._sprite.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this._onMouseDraggedEventHandler);
            this._sprite.removeEventHandler(MouseEvent.MOUSE_RELEASED, this._onMouseReleasedEventHandler);
            this._sprite = null;
            this._player = null;
        }
    }

    private static class ClickPlayerEventHandler
    implements Disposable {
        private EventHandler<MouseEvent> _onMouseClickedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent aEvent) {
                if (ClickPlayerEventHandler.this._player != null && ClickPlayerEventHandler.this._player.isVisible()) {
                    LOGGER.log(Level.FINE, "Player mouse press X := " + aEvent.getSceneX());
                    LOGGER.log(Level.FINE, "Player mouse press Y := " + aEvent.getSceneY());
                    ClickPlayerEventHandler.this._player.click();
                    aEvent.consume();
                }
            }
        };
        private P _player;
        private Node _sprite;
        final /* synthetic */ FxCheckerboardViewer this$0;

        public ClickPlayerEventHandler(P aPlayer, Node aSprite) {
            this.this$0 = var1_1;
            aSprite.setOnMouseClicked(this._onMouseClickedEventHandler);
            this._player = aPlayer;
            this._sprite = aSprite;
        }

        public void dispose() {
            this._sprite.removeEventHandler(MouseEvent.MOUSE_CLICKED, this._onMouseClickedEventHandler);
            this._sprite = null;
            this._player = null;
        }
    }
}

