// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.checkerboard.alt.javafx;

import org.refcodes.checkerboard.Player;

import javafx.scene.paint.Color;

/**
 * A factory for creating FxChessboard objects.
 *
 * @author steiner
 * @param <P> the generic type
 * @param <S> the generic type
 */
public interface FxChessboardFactory<P extends Player<P, S>, S> extends FxBackgroundFactory<P, S> {

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * With even field color.
	 *
	 * @param aEvenFieldColor the a even field color
	 * @return the fx chessboard factory
	 */
	public FxChessboardFactory<P, S> withEvenFieldColor( Color aEvenFieldColor );

	/**
	 * With odd field color.
	 *
	 * @param aOddFieldColor the a odd field color
	 * @return the fx chessboard factory
	 */
	public FxChessboardFactory<P, S> withOddFieldColor( Color aOddFieldColor );

	/**
	 * With field gap color.
	 *
	 * @param aFieldGapColor the a field gap color
	 * @return the fx chessboard factory
	 */
	public FxChessboardFactory<P, S> withFieldGapColor( Color aFieldGapColor );

	/**
	 * Gets the even field color.
	 *
	 * @return the even field color
	 */
	public Color getEvenFieldColor();

	/**
	 * Sets the even field color.
	 *
	 * @param eEvenFieldColor the new even field color
	 */
	public void setEvenFieldColor( Color eEvenFieldColor );

	/**
	 * Gets the odd field color.
	 *
	 * @return the odd field color
	 */
	public Color getOddFieldColor();

	/**
	 * Sets the odd field color.
	 *
	 * @param aOddFieldColor the new odd field color
	 */
	public void setOddFieldColor( Color aOddFieldColor );

	/**
	 * Sets the field gap color.
	 *
	 * @param aFieldGapColor the new field gap color
	 */
	public void setFieldGapColor( Color aFieldGapColor );

	/**
	 * Gets the field gap color.
	 *
	 * @return the field gap color
	 */
	public Color getFieldGapColor();
}
