/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard.alt.javafx.impls;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javafx.animation.FadeTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.refcodes.checkerboard.ChangePositionEvent;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.CheckerboardEvent;
import org.refcodes.checkerboard.CheckerboardObserver;
import org.refcodes.checkerboard.DraggabilityChangedEvent;
import org.refcodes.checkerboard.GridDimensionChangedEvent;
import org.refcodes.checkerboard.GridModeChangedEvent;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.PlayerAddedEvent;
import org.refcodes.checkerboard.PlayerEvent;
import org.refcodes.checkerboard.PlayerRemovedEvent;
import org.refcodes.checkerboard.PositionChangedEvent;
import org.refcodes.checkerboard.StateChangedEvent;
import org.refcodes.checkerboard.ViewportDimensionChangedEvent;
import org.refcodes.checkerboard.ViewportOffsetChangedEvent;
import org.refcodes.checkerboard.VisibilityChangedEvent;
import org.refcodes.checkerboard.alt.javafx.FxBackgroundFactory;
import org.refcodes.checkerboard.alt.javafx.FxCheckerboardViewer;
import org.refcodes.checkerboard.alt.javafx.FxSpriteFactory;
import org.refcodes.checkerboard.impls.AbstractGraphicalCheckerboardViewer;
import org.refcodes.component.ConfigureException;
import org.refcodes.component.InitializeException;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.VetoException;
import org.refcodes.graphical.FieldDimension;
import org.refcodes.graphical.GridDimension;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.MoveMode;
import org.refcodes.graphical.Position;
import org.refcodes.graphical.ViewportDimension;
import org.refcodes.graphical.ViewportOffset;
import org.refcodes.graphical.ext.javafx.impls.FxViewportPaneImpl;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.mixin.Disposable;

public class FxCheckerboardViewerImpl<P extends Player<P, S>, S>
extends AbstractGraphicalCheckerboardViewer<P, S, Node, FxSpriteFactory<S>, FxBackgroundFactory<P, S>, FxCheckerboardViewer<P, S>>
implements FxCheckerboardViewer<P, S>,
CheckerboardObserver<P, S> {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final int TIMER_PERIOD_MS = 100;
    private static final int TIMER_DELAY_MS = 1000;
    private static final int RESIZE_FINISHED_DELAY_IN_MS = 150;
    private Scene _scene = null;
    private Stage _stage = null;
    private Group _checkers = new Group();
    private FxViewportPaneImpl _viewportPane;
    private int _movePlayerDurationInMillis = 150;
    private int _adjustPlayerDurationInMillis = 50;
    private int _addPlayerDurationInMillis = 1000;
    private int _removePlayerDurationInMillis = 1000;
    private int _playerVisibilityDurationInMillis = 100;
    private int _changePlayerStateInMillis = 300;
    private int _resizeGridInMillis = 500;
    private int _initGridInMillis = 1500;
    private boolean _isVisible;
    private Node _backgroundNode = null;
    private Map<P, Node> _playerToSprite = new HashMap<P, Node>();
    private Map<P, DragPlayerEventHandler> _playerToDragEventHandler = new HashMap<P, DragPlayerEventHandler>();
    private ResizeEventHandler _stageHandler;
    private long _lastResizeTimeInMs = -1L;
    private Timer _viewTimer = null;
    private double _bordersH = Double.NaN;
    private double _bordersV = Double.NaN;
    private double _windowDecorationH = Double.NaN;
    private double _windowDecorationV = Double.NaN;

    public FxCheckerboardViewerImpl(Checkerboard<P, S> aCheckerboard, Stage aStage, FxViewportPaneImpl aViewportPane) {
        aCheckerboard.subscribeObserver((Object)this);
        this._stage = aStage;
        this._viewportPane = aViewportPane;
    }

    public FxCheckerboardViewerImpl(Checkerboard<P, S> aCheckerboard, Stage aStage) {
        this(aCheckerboard, aStage, new FxViewportPaneImpl());
    }

    @Override
    public void setMovePlayerDurationInMillis(int aMovePlayerDurationInMillis) {
        this._movePlayerDurationInMillis = aMovePlayerDurationInMillis;
    }

    @Override
    public int getAddPlayerDurationInMillis() {
        return this._addPlayerDurationInMillis;
    }

    @Override
    public void setAddPlayerDurationInMillis(int aAddPlayerDurationInMillis) {
        this._addPlayerDurationInMillis = aAddPlayerDurationInMillis;
    }

    @Override
    public int getRemovePlayerDurationInMillis() {
        return this._removePlayerDurationInMillis;
    }

    @Override
    public void setRemovePlayerDurationInMillis(int aRemovePlayerDurationInMillis) {
        this._removePlayerDurationInMillis = aRemovePlayerDurationInMillis;
    }

    @Override
    public int getChangePlayerStateInMillis() {
        return this._changePlayerStateInMillis;
    }

    @Override
    public void setChangePlayerStateInMillis(int changePlayerStateInMillis) {
        this._changePlayerStateInMillis = changePlayerStateInMillis;
    }

    @Override
    public int getMovePlayerDurationInMillis() {
        return this._movePlayerDurationInMillis;
    }

    public void setVisible(boolean isVisible) {
        if (this._stage != null) {
            if (isVisible) {
                if (Platform.isFxApplicationThread()) {
                    this._stage.show();
                } else {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FxCheckerboardViewerImpl.this._stage.show();
                        }
                    });
                }
            } else if (Platform.isFxApplicationThread()) {
                this._stage.hide();
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FxCheckerboardViewerImpl.this._stage.hide();
                    }
                });
            }
        }
        this._isVisible = isVisible;
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public int getViewportOffsetX() {
        return this._viewportPane.getViewportOffsetX();
    }

    public int getViewportOffsetY() {
        return this._viewportPane.getViewportOffsetY();
    }

    public double getDragOpacity() {
        return this._viewportPane.getDragOpacity();
    }

    public void setDragOpacity(double aOpacity) {
        this._viewportPane.setDragOpacity(aOpacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize() throws InitializeException {
        if (this._viewTimer == null) {
            FxCheckerboardViewerImpl fxCheckerboardViewerImpl = this;
            synchronized (fxCheckerboardViewerImpl) {
                if (this._viewTimer == null) {
                    this._viewTimer = new Timer(true);
                    this._viewTimer.schedule((TimerTask)new ViewDaemon(), 1000L, 100L);
                }
            }
        }
        if (Platform.isFxApplicationThread()) {
            this.runInitialize();
            if (this._stage != null) {
                this.runInitialize(this._stage);
            }
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        FxCheckerboardViewerImpl.this.runInitialize();
                        if (FxCheckerboardViewerImpl.this._stage != null) {
                            FxCheckerboardViewerImpl.this.runInitialize(FxCheckerboardViewerImpl.this._stage);
                        }
                    }
                    catch (InitializeException e) {
                        LOGGER.error("Exception during initialization: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        LOGGER.debug("Destroying ...");
        if (this._viewTimer != null) {
            FxCheckerboardViewerImpl fxCheckerboardViewerImpl = this;
            synchronized (fxCheckerboardViewerImpl) {
                if (this._viewTimer != null) {
                    this._viewTimer.cancel();
                    this._viewTimer.purge();
                    this._viewTimer = null;
                }
            }
        }
    }

    private void runInitialize() throws InitializeException {
        try {
            LOGGER.debug("Initializing ...");
            if (this.getViewportWidth() == -1) {
                this.setViewportWidth(this.getGridWidth());
            }
            if (this.getViewportHeight() == -1) {
                this.setViewportHeight(this.getGridHeight());
            }
            if (this.getViewportWidth() == -1 || this.getViewportHeight() == -1) {
                throw new IllegalStateException("The viewport dimension for the checkerboard must be set!");
            }
            this.fxResizeViewport((ViewportDimension)this, null, (ViewportOffset)this, this._initGridInMillis);
            this.fxResizeGrid((GridDimension)this, null, this._initGridInMillis);
            switch (this.getScaleMode()) {
                case SCALE_GRID: 
                case SCALE_FIELDS: {
                    this._viewportPane.setContent((Node)this._checkers);
                    this._viewportPane.setViewportOffset((ViewportOffset)this);
                    this._viewportPane.setFieldDimension((FieldDimension)this);
                    this._scene = new Scene((Parent)this._viewportPane, (Paint)Color.BLACK);
                    break;
                }
                case NONE: {
                    StackPane thePane = new StackPane();
                    thePane.getChildren().add((Object)this._checkers);
                    StackPane.setAlignment((Node)this._checkers, (Pos)Pos.CENTER);
                    this._scene = new Scene((Parent)thePane, (Paint)Color.BLACK);
                }
            }
        }
        catch (Exception e) {
            throw new InitializeException("Exception during initialization: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    private void runInitialize(Stage aContext) throws ConfigureException {
        try {
            if (this._stage != aContext) {
                if (this._stageHandler != null) {
                    this._stageHandler.dispose();
                }
                this._stage = aContext;
                this._stageHandler = new ResizeEventHandler(aContext);
            }
            this.fxResizeStage();
        }
        catch (Exception e) {
            throw new ConfigureException((Object)aContext, "Exception during initialization: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
        }
    }

    public void onPlayerEvent(PlayerEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) {
    }

    public void onCheckerboardEvent(CheckerboardEvent<P, S> aEvent) {
    }

    public void onChangePositionEvent(ChangePositionEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) throws VetoException {
        LOGGER.debug(aEvent.toString());
    }

    public void onPositionChangedEvent(PositionChangedEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) {
        LOGGER.debug(aEvent.toString());
        this.fxMovePlayer((Player)aEvent.getSource(), aEvent.getPrecedingPosition(), this._movePlayerDurationInMillis);
    }

    public void onVisibilityChangedEvent(VisibilityChangedEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) {
        LOGGER.debug(aEvent.toString());
        this.fxPlayerVisibility((Player)aEvent.getSource(), this._playerVisibilityDurationInMillis);
    }

    public void onDraggabilityChangedEvent(DraggabilityChangedEvent<P> aEvent, Checkerboard<P, S> aCheckerboard) {
        LOGGER.debug(aEvent.toString());
        this.fxPlayerDraggability((Player)aEvent.getSource());
    }

    public void onStateChangedEvent(StateChangedEvent<P, S> aEvent, Checkerboard<P, S> aCheckerboard) {
        LOGGER.debug(aEvent.toString());
        this.fxRemovePlayer((Player)aEvent.getSource(), this._changePlayerStateInMillis / 2);
        this.fxAddPlayer((Player)aEvent.getSource(), this._changePlayerStateInMillis / 2);
    }

    public void onPlayerAddedEvent(PlayerAddedEvent<P, S> aEvent) {
        LOGGER.debug(aEvent.toString());
        this.fxAddPlayer(aEvent.getPlayer(), this._addPlayerDurationInMillis);
    }

    public void onPlayerRemovedEvent(PlayerRemovedEvent<P, S> aEvent) {
        LOGGER.debug(aEvent.toString());
        this.fxRemovePlayer(aEvent.getPlayer(), this._removePlayerDurationInMillis);
    }

    public void onGridModeChangedEvent(GridModeChangedEvent<P, S> aEvent) {
        LOGGER.debug(aEvent.toString());
        this._viewportPane.setGridMode(aEvent.getGridMode());
        this.initMinStageWidth();
        this.initMinStageHeight();
    }

    public void onGridDimensionChangedEvent(GridDimensionChangedEvent<P, S> aEvent) {
        LOGGER.debug(aEvent.toString());
        this.fxResizeGrid((GridDimension)aEvent, aEvent.getPrecedingGridDimension(), this._resizeGridInMillis);
    }

    public void onViewportOffsetChangedEvent(ViewportOffsetChangedEvent<P, S> aEvent) {
        LOGGER.debug(aEvent.toString());
        this._viewportPane.setViewportOffset((ViewportOffset)this);
    }

    public void onViewportDimensionChangedEvent(ViewportDimensionChangedEvent<P, S> aEvent) {
        LOGGER.debug(aEvent.toString());
        this.fxResizeViewport((ViewportDimension)aEvent, aEvent.getPrecedingViewportDimension(), aEvent.getViewportOffset(), this._resizeGridInMillis);
    }

    protected void resetPlayers(int aDurationInMillis) {
        for (Player ePlayer : this.getCheckerboard().getPlayers()) {
            this.fxResetPlayer(ePlayer, aDurationInMillis);
        }
    }

    protected void scalePlayers(FieldDimension aFieldDimension, FieldDimension aPrecedingFieldDimension) {
        for (Player ePlayer : this.getCheckerboard().getPlayers()) {
            this.fxScalePlayer(ePlayer, aFieldDimension, aPrecedingFieldDimension);
        }
    }

    protected void hidePlayers(int aDurationInMillis) {
        for (Player ePlayer : this.getCheckerboard().getPlayers()) {
            this.fxHidePlayer(ePlayer, aDurationInMillis);
        }
    }

    private int toPixelPositionX(Position aPosition) {
        return (this.getFieldWidth() + this.getFieldGap()) * aPosition.getPositionX() + (this.getGridMode() == GridMode.CLOSED ? this.getFieldGap() : 0);
    }

    private int toPixelPositionY(Position aPosition) {
        return (this.getFieldHeight() + this.getFieldGap()) * aPosition.getPositionY() + (this.getGridMode() == GridMode.CLOSED ? this.getFieldGap() : 0);
    }

    private boolean isViewportPosX(int aPositionX) {
        return aPositionX >= this.getViewportOffsetX() && aPositionX < this.getViewportWidth() + this.getViewportOffsetX();
    }

    private boolean isViewportPosY(int aPositionY) {
        return aPositionY >= this.getViewportOffsetY() && aPositionY < this.getViewportHeight() + this.getViewportOffsetY();
    }

    private boolean isViewport(Position aPosition) {
        return this.isViewportPosX(aPosition.getPositionX()) && this.isViewportPosY(aPosition.getPositionY());
    }

    private void initBordersH(double aWindowWidth) {
        if (Double.isNaN(this._bordersH)) {
            double theBoardersH = aWindowWidth - (double)((this.getViewportWidth() - 1) * this.getFieldGap());
            if (this.getCheckerboard().getGridMode() == GridMode.CLOSED) {
                theBoardersH -= (double)(this.getFieldGap() * 2);
            }
            theBoardersH -= (double)(this.getViewportWidth() * this.getFieldWidth());
            theBoardersH = this.getCheckerboard().getGridMode() == GridMode.CLOSED ? (theBoardersH += (double)this.getFieldGap()) : (theBoardersH -= (double)this.getFieldGap());
            LOGGER.debug("Horizontal (left and right) [phantom] borders from width <" + aWindowWidth + "> := " + theBoardersH);
            this._windowDecorationH = this._stage.getWidth() - this._scene.getWidth();
            this._bordersH = theBoardersH;
        }
    }

    private void initBordersV(double aWindowHeight) {
        if (Double.isNaN(this._bordersV)) {
            double theBoardersV = aWindowHeight - (double)((this.getViewportHeight() - 1) * this.getFieldGap());
            if (this.getCheckerboard().getGridMode() == GridMode.CLOSED) {
                theBoardersV -= (double)(this.getFieldGap() * 2);
            }
            theBoardersV -= (double)(this.getViewportHeight() * this.getFieldHeight());
            theBoardersV = this.getCheckerboard().getGridMode() == GridMode.CLOSED ? (theBoardersV += (double)this.getFieldGap()) : (theBoardersV -= (double)this.getFieldGap());
            LOGGER.debug("Vertical (top and bottom) [phantom] borders from height <" + aWindowHeight + "> := " + theBoardersV);
            this._windowDecorationV = this._stage.getHeight() - this._scene.getHeight();
            this._bordersV = theBoardersV;
        }
    }

    private void initMinStageWidth() {
        if (this._stage != null && this._scene != null) {
            if (Double.isNaN(this._bordersH)) {
                this.initBordersH(this._scene.getWidth());
            }
            if (!Double.isNaN(this._bordersH)) {
                int theWidth = (int)this._bordersH;
                this._stage.setMinWidth((double)(theWidth += this.getViewportWidth() * this.getFieldWidth() + this.getViewportWidth() * this.getFieldGap()) + this._windowDecorationH);
            }
        }
    }

    private void initMinStageHeight() {
        if (this._stage != null && this._scene != null) {
            if (Double.isNaN(this._bordersV)) {
                this.initBordersV(this._scene.getHeight());
            }
            if (!Double.isNaN(this._bordersV)) {
                int theHeight = (int)this._bordersV;
                this._stage.setMinHeight((double)(theHeight += this.getViewportHeight() * this.getFieldHeight() + this.getViewportHeight() * this.getFieldGap()) + this._windowDecorationV);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxMovePlayer(P aPlayer, Position aPrecedingPosition, final int aDurationInMillis) {
        Node theSprite;
        FxCheckerboardViewerImpl fxCheckerboardViewerImpl = this;
        synchronized (fxCheckerboardViewerImpl) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        Runnable theRunner = new Runnable((Player)aPlayer){
            private final /* synthetic */ Player val$aPlayer;
            {
                this.val$aPlayer = player;
            }

            @Override
            public void run() {
                if (FxCheckerboardViewerImpl.this._checkers.getChildren().remove((Object)theSprite)) {
                    FxCheckerboardViewerImpl.this._checkers.getChildren().add((Object)theSprite);
                    if (FxCheckerboardViewerImpl.this.getMoveMode() == MoveMode.SMOOTH) {
                        TranslateTransition theTransition = new TranslateTransition(Duration.millis((double)aDurationInMillis), theSprite);
                        theTransition.setByX((double)FxCheckerboardViewerImpl.this.toPixelPositionX((Position)this.val$aPlayer) - theSprite.getTranslateX());
                        theTransition.setByY((double)FxCheckerboardViewerImpl.this.toPixelPositionY((Position)this.val$aPlayer) - theSprite.getTranslateY());
                        theTransition.setCycleCount(1);
                        theTransition.setAutoReverse(false);
                        theTransition.play();
                    } else {
                        theSprite.setTranslateX((double)FxCheckerboardViewerImpl.this.toPixelPositionX((Position)this.val$aPlayer));
                        theSprite.setTranslateY((double)FxCheckerboardViewerImpl.this.toPixelPositionY((Position)this.val$aPlayer));
                    }
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxScalePlayer(P aPlayer, FieldDimension aFieldDimension, FieldDimension aPrecedingFieldDimension) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        theSprite.setScaleX((double)aFieldDimension.getFieldWidth() / theSprite.getBoundsInLocal().getWidth());
        theSprite.setScaleY((double)aFieldDimension.getFieldHeight() / theSprite.getBoundsInLocal().getHeight());
        double theLayoutX = ((double)aFieldDimension.getFieldWidth() - theSprite.getBoundsInLocal().getWidth()) / 2.0;
        double theLayoutY = ((double)aFieldDimension.getFieldHeight() - theSprite.getBoundsInLocal().getHeight()) / 2.0;
        theSprite.setLayoutX(theLayoutX);
        theSprite.setLayoutY(theLayoutY);
        theSprite.setTranslateX((double)this.toPixelPositionX((Position)aPlayer));
        theSprite.setTranslateY((double)this.toPixelPositionY((Position)aPlayer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxResetPlayer(P aPlayer, int aDurationInMillis) {
        Node thePrevSprite;
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = (Node)((FxSpriteFactory)this.getSpriteFactory()).toInstance(aPlayer.getState(), this);
            thePrevSprite = this._playerToSprite.put(aPlayer, theSprite);
        }
        if (aPlayer.isDraggable()) {
            DragPlayerEventHandler theDragEventHandler = new DragPlayerEventHandler(this, aPlayer, theSprite);
            this._playerToDragEventHandler.put(aPlayer, theDragEventHandler);
        }
        theSprite.setOpacity(0.0);
        Point2D thePoint = theSprite.localToParent(0.0, 0.0);
        theSprite.setLayoutX(-thePoint.getX());
        theSprite.setLayoutY(-thePoint.getY());
        theSprite.setTranslateX((double)this.toPixelPositionX((Position)aPlayer));
        theSprite.setTranslateY((double)this.toPixelPositionY((Position)aPlayer));
        this._checkers.getChildren().add((Object)theSprite);
        if (thePrevSprite != null) {
            this._checkers.getChildren().remove((Object)thePrevSprite);
        }
        Runnable theRunner = new Runnable((Player)aPlayer, theSprite, aDurationInMillis){
            private final /* synthetic */ Player val$aPlayer;
            private final /* synthetic */ Node val$theSprite;
            private final /* synthetic */ int val$aDurationInMillis;
            {
                this.val$aPlayer = player;
                this.val$theSprite = node;
                this.val$aDurationInMillis = n;
            }

            @Override
            public void run() {
                if (this.val$aPlayer.isVisible() && this.val$theSprite.getOpacity() == 0.0) {
                    FadeTransition theTransition = new FadeTransition(Duration.millis((double)this.val$aDurationInMillis), this.val$theSprite);
                    theTransition.setFromValue(0.0);
                    theTransition.setToValue(1.0);
                    theTransition.setCycleCount(1);
                    theTransition.setAutoReverse(false);
                    theTransition.play();
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxHidePlayer(P aPlayer, final int aDurationInMillis) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        if (theSprite != null) {
            if (aDurationInMillis == 0) {
                theSprite.setOpacity(0.0);
            } else if (theSprite.getOpacity() != 0.0) {
                Runnable theRunner = new Runnable(){

                    @Override
                    public void run() {
                        FadeTransition theTransition = new FadeTransition(Duration.millis((double)aDurationInMillis), theSprite);
                        theTransition.setFromValue(theSprite.getOpacity());
                        theTransition.setToValue(0.0);
                        theTransition.setCycleCount(1);
                        theTransition.setAutoReverse(false);
                        theTransition.play();
                    }
                };
                if (Platform.isFxApplicationThread()) {
                    theRunner.run();
                } else {
                    Platform.runLater((Runnable)theRunner);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxAddPlayer(P aPlayer, int aDurationInMillis) {
        Node theSprite = (Node)((FxSpriteFactory)this.getSpriteFactory()).toInstance(aPlayer.getState(), this);
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            this._playerToSprite.put(aPlayer, theSprite);
        }
        if (aPlayer.isDraggable()) {
            DragPlayerEventHandler theDragEventHandler = new DragPlayerEventHandler(this, aPlayer, theSprite);
            this._playerToDragEventHandler.put(aPlayer, theDragEventHandler);
        }
        Point2D thePoint = theSprite.localToParent(0.0, 0.0);
        theSprite.setLayoutX(-thePoint.getX());
        theSprite.setLayoutY(-thePoint.getY());
        theSprite.setTranslateX((double)this.toPixelPositionX((Position)aPlayer));
        theSprite.setTranslateY((double)this.toPixelPositionY((Position)aPlayer));
        Runnable theRunner = new Runnable((Player)aPlayer, theSprite, aDurationInMillis){
            private final /* synthetic */ Player val$aPlayer;
            private final /* synthetic */ Node val$theSprite;
            private final /* synthetic */ int val$aDurationInMillis;
            {
                this.val$aPlayer = player;
                this.val$theSprite = node;
                this.val$aDurationInMillis = n;
            }

            @Override
            public void run() {
                if (FxCheckerboardViewerImpl.this.isViewport((Position)this.val$aPlayer)) {
                    this.val$theSprite.setOpacity(0.0);
                    FxCheckerboardViewerImpl.this._checkers.getChildren().add((Object)this.val$theSprite);
                    if (this.val$aPlayer.isVisible()) {
                        FadeTransition theTransition = new FadeTransition(Duration.millis((double)this.val$aDurationInMillis), this.val$theSprite);
                        theTransition.setFromValue(0.0);
                        theTransition.setToValue(1.0);
                        theTransition.setCycleCount(1);
                        theTransition.setAutoReverse(false);
                        theTransition.play();
                    }
                } else {
                    this.val$theSprite.setVisible(true);
                    FxCheckerboardViewerImpl.this._checkers.getChildren().add((Object)this.val$theSprite);
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxRemovePlayer(P aPlayer, int aDurationInMillis) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.remove(aPlayer);
        }
        DragPlayerEventHandler theDragEventHandler = this._playerToDragEventHandler.remove(aPlayer);
        if (theDragEventHandler != null) {
            theDragEventHandler.dispose();
        }
        if (theSprite != null) {
            FadeTransition theTransition = new FadeTransition(Duration.millis((double)aDurationInMillis), theSprite);
            theTransition.setFromValue(1.0);
            theTransition.setToValue(0.0);
            theTransition.setCycleCount(1);
            theTransition.setAutoReverse(false);
            theTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    FxCheckerboardViewerImpl.this._checkers.getChildren().remove((Object)theSprite);
                }
            });
            theTransition.play();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxPlayerDraggability(P aPlayer) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        if (theSprite != null) {
            DragPlayerEventHandler theDragEventHandler;
            if (aPlayer.isDraggable() && !this._playerToDragEventHandler.containsKey(aPlayer)) {
                theDragEventHandler = new DragPlayerEventHandler(this, aPlayer, theSprite);
                this._playerToDragEventHandler.put(aPlayer, theDragEventHandler);
            } else {
                theDragEventHandler = this._playerToDragEventHandler.remove(aPlayer);
                if (theDragEventHandler != null) {
                    theDragEventHandler.dispose();
                }
            }
        } else {
            throw new IllegalStateException("The player <" + aPlayer + "> is unknwon by this checkerboard.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fxPlayerVisibility(P aPlayer, int aDurationInMillis) {
        Node theSprite;
        Map<P, Node> map = this._playerToSprite;
        synchronized (map) {
            theSprite = this._playerToSprite.get(aPlayer);
        }
        if (theSprite != null) {
            FadeTransition theTransition = new FadeTransition(Duration.millis((double)aDurationInMillis), theSprite);
            theTransition.setFromValue((double)(!aPlayer.isVisible() ? 1 : 0));
            theTransition.setToValue((double)(aPlayer.isVisible() ? 1 : 0));
            theTransition.setCycleCount(1);
            theTransition.setAutoReverse(false);
            theTransition.play();
        }
    }

    private synchronized void fxResizeViewport(final ViewportDimension aDimension, ViewportDimension aPrecedingDimension, ViewportOffset aOffset, int aDurationInMillis) {
        Runnable theRunner = new Runnable(){

            @Override
            public void run() {
                FxCheckerboardViewerImpl.this._viewportPane.setFieldDimension((FieldDimension)FxCheckerboardViewerImpl.this);
                FxCheckerboardViewerImpl.this._viewportPane.setViewportDimension(aDimension);
                FxCheckerboardViewerImpl.this.fxResizeStage();
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    private synchronized void fxResizeGrid(final GridDimension aDimension, final GridDimension aPrecedingDimension, final int aDurationInMillis) {
        Runnable theRunner = new Runnable(){

            @Override
            public void run() {
                if (FxCheckerboardViewerImpl.this.getBackgroundFactory() != null) {
                    FxCheckerboardViewerImpl.this.fxUpdateBackground(aDimension, aPrecedingDimension, aDurationInMillis);
                }
                FxCheckerboardViewerImpl.this.fxResizeStage();
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    private void fxResizeStage() {
        Runnable theRunner = new Runnable(){

            @Override
            public void run() {
                if (FxCheckerboardViewerImpl.this._stage != null) {
                    switch (FxCheckerboardViewerImpl.this.getScaleMode()) {
                        case SCALE_GRID: 
                        case SCALE_FIELDS: {
                            if (FxCheckerboardViewerImpl.this._stage == null) break;
                            FxCheckerboardViewerImpl.this._stage.setScene(FxCheckerboardViewerImpl.this._scene);
                            break;
                        }
                        case NONE: {
                            if (FxCheckerboardViewerImpl.this._stage == null) break;
                            FxCheckerboardViewerImpl.this._stage.setScene(FxCheckerboardViewerImpl.this._scene);
                            FxCheckerboardViewerImpl.this._stage.sizeToScene();
                            FxCheckerboardViewerImpl.this._stage.setResizable(false);
                        }
                    }
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            theRunner.run();
        } else {
            Platform.runLater((Runnable)theRunner);
        }
    }

    private void fxUpdateBackground(GridDimension aDimension, GridDimension aPrecedingDimension, int aDurationInMillis) {
        int index = 0;
        final Node theOldBackgroundNode = this._backgroundNode;
        Node theNewBackgroundNode = (Node)((FxBackgroundFactory)this.getBackgroundFactory()).toInstance(this);
        FadeTransition theTransition = new FadeTransition(Duration.millis((double)aDurationInMillis));
        if (theOldBackgroundNode != null) {
            index = this._checkers.getChildren().indexOf((Object)theOldBackgroundNode);
            theTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    FxCheckerboardViewerImpl.this._checkers.getChildren().remove((Object)theOldBackgroundNode);
                    FxCheckerboardViewerImpl.this.fxResizeStage();
                }
            });
        }
        Node theTransitionNode = null;
        double theFromValue = 0.0;
        double theToValue = 1.0;
        if (aPrecedingDimension != null && aDimension.getGridWidth() >= aPrecedingDimension.getGridWidth() && aDimension.getGridHeight() >= aPrecedingDimension.getGridHeight()) {
            theTransitionNode = theNewBackgroundNode;
            theNewBackgroundNode.setOpacity(0.0);
            theFromValue = 0.0;
            theToValue = 1.0;
            ++index;
        } else if (aPrecedingDimension != null && aDimension.getGridWidth() <= aPrecedingDimension.getGridWidth() && aDimension.getGridHeight() <= aPrecedingDimension.getGridHeight()) {
            theTransitionNode = theOldBackgroundNode;
            theFromValue = 1.0;
            theToValue = 0.0;
        }
        if (aPrecedingDimension == null) {
            theTransitionNode = theNewBackgroundNode;
            theNewBackgroundNode.setOpacity(0.0);
        }
        this._backgroundNode = theNewBackgroundNode;
        this._checkers.getChildren().add(index, (Object)this._backgroundNode);
        theTransition.setNode(theTransitionNode);
        theTransition.setFromValue(theFromValue);
        theTransition.setToValue(theToValue);
        theTransition.setCycleCount(1);
        theTransition.setAutoReverse(false);
        theTransition.play();
    }

    private static class DragPlayerEventHandler
    implements Disposable {
        private double _sceneX;
        private double _sceneY;
        private double _translateX;
        private double _translateY;
        private P _player;
        private Node _sprite;
        private EventHandler<MouseEvent> _onMousePressedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent aEvent) {
                if (DragPlayerEventHandler.this._player.isVisible()) {
                    Node theSprite = (Node)aEvent.getSource();
                    theSprite.setOpacity(0.5);
                    DragPlayerEventHandler.this._sceneX = aEvent.getSceneX();
                    DragPlayerEventHandler.this._sceneY = aEvent.getSceneY();
                    DragPlayerEventHandler.this._translateX = theSprite.getTranslateX();
                    DragPlayerEventHandler.this._translateY = theSprite.getTranslateY();
                    LOGGER.debug("Player mouse press X := " + aEvent.getSceneX());
                    LOGGER.debug("Player mouse press Y := " + aEvent.getSceneY());
                    aEvent.consume();
                }
            }
        };
        private EventHandler<MouseEvent> _onMouseDraggedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent aEvent) {
                if (DragPlayerEventHandler.this._player.isVisible()) {
                    Node theSprite = (Node)aEvent.getSource();
                    double theSceneOffsetX = aEvent.getSceneX() - DragPlayerEventHandler.this._sceneX;
                    double theSceneOffsetY = aEvent.getSceneY() - DragPlayerEventHandler.this._sceneY;
                    double theTranslateX = DragPlayerEventHandler.this._translateX + theSceneOffsetX;
                    double theTranslateY = DragPlayerEventHandler.this._translateY + theSceneOffsetY;
                    int theBorderWidth = (int)DragPlayerEventHandler.this.this$0._bordersH / 2;
                    int theBorderHeight = (int)DragPlayerEventHandler.this.this$0._bordersV / 2;
                    if (theTranslateX >= (double)(-theBorderWidth) && theTranslateX <= (double)((DragPlayerEventHandler.this.this$0.getFieldWidth() + DragPlayerEventHandler.this.this$0.getFieldGap()) * (DragPlayerEventHandler.this.this$0.getGridWidth() - 1) + theBorderWidth)) {
                        theSprite.setTranslateX(theTranslateX);
                    }
                    if (theTranslateY >= (double)(-theBorderHeight) && theTranslateY <= (double)((DragPlayerEventHandler.this.this$0.getFieldHeight() + DragPlayerEventHandler.this.this$0.getFieldGap()) * (DragPlayerEventHandler.this.this$0.getGridHeight() - 1) + theBorderHeight)) {
                        theSprite.setTranslateY(theTranslateY);
                    }
                    aEvent.consume();
                }
            }
        };
        private EventHandler<MouseEvent> _onMouseReleasedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent aEvent) {
                Node theSprite = (Node)aEvent.getSource();
                if (DragPlayerEventHandler.this._player.isVisible()) {
                    double theSceneOffsetX = aEvent.getSceneX() - DragPlayerEventHandler.this._sceneX;
                    double theSceneOffsetY = aEvent.getSceneY() - DragPlayerEventHandler.this._sceneY;
                    double theStepX = Math.round(theSceneOffsetX / (double)(DragPlayerEventHandler.this.this$0.getFieldWidth() + DragPlayerEventHandler.this.this$0.getFieldGap()));
                    double theStepY = Math.round(theSceneOffsetY / (double)(DragPlayerEventHandler.this.this$0.getFieldHeight() + DragPlayerEventHandler.this.this$0.getFieldGap()));
                    int thePosX = (int)((double)DragPlayerEventHandler.this._player.getPositionX() + theStepX);
                    int thePosY = (int)((double)DragPlayerEventHandler.this._player.getPositionY() + theStepY);
                    if (thePosX >= DragPlayerEventHandler.this.this$0.getGridWidth() || thePosX < 0 || thePosY >= DragPlayerEventHandler.this.this$0.getGridHeight() || thePosY < 0) {
                        theStepY = 0.0;
                        theStepX = 0.0;
                        thePosY = (int)((double)DragPlayerEventHandler.this._player.getPositionY() + theStepY);
                        thePosX = (int)((double)DragPlayerEventHandler.this._player.getPositionX() + theStepX);
                    }
                    try {
                        DragPlayerEventHandler.this._player.setPosition(thePosX, thePosY);
                    }
                    catch (VetoException.VetoRuntimeException e) {
                        LOGGER.warn("Change player <" + DragPlayerEventHandler.this._player + "> position to (" + thePosX + ", " + thePosY + ") has been vetoed: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                        theStepX = 0.0;
                        theStepY = 0.0;
                    }
                    if (theStepX == 0.0 && theStepY == 0.0) {
                        DragPlayerEventHandler.this.this$0.fxMovePlayer(DragPlayerEventHandler.this._player, (Position)DragPlayerEventHandler.this._player, DragPlayerEventHandler.this.this$0._adjustPlayerDurationInMillis);
                    }
                    theSprite.setOpacity(1.0);
                    aEvent.consume();
                }
            }
        };
        final /* synthetic */ FxCheckerboardViewerImpl this$0;

        public DragPlayerEventHandler(P aPlayer, Node aSprite) {
            this.this$0 = var1_1;
            aSprite.setOnMousePressed(this._onMousePressedEventHandler);
            aSprite.setOnMouseDragged(this._onMouseDraggedEventHandler);
            aSprite.setOnMouseReleased(this._onMouseReleasedEventHandler);
            this._player = aPlayer;
            this._sprite = aSprite;
        }

        public void dispose() {
            this._sprite.setOnMousePressed(null);
            this._sprite.setOnMouseDragged(null);
            this._sprite.setOnMouseReleased(null);
            this._sprite = null;
            this._player = null;
        }
    }

    private class ResizeEventHandler
    implements Disposable {
        private Stage _window;
        private ChangeListener<Number> _onWindowWidthChangedEventHandler = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number aOldValue, Number aNewValue) {
                FxCheckerboardViewerImpl.this._lastResizeTimeInMs = System.currentTimeMillis();
                if (Math.abs(aNewValue.doubleValue() - aOldValue.doubleValue()) > 10.0) {
                    return;
                }
                if (Double.isNaN(FxCheckerboardViewerImpl.this._bordersH) && !Double.isNaN(aOldValue.doubleValue())) {
                    FxCheckerboardViewerImpl.this.initBordersH(aOldValue.doubleValue());
                    FxCheckerboardViewerImpl.this.initMinStageWidth();
                }
                switch (FxCheckerboardViewerImpl.this.getScaleMode()) {
                    case SCALE_GRID: {
                        int theNewViewportWidth = ResizeEventHandler.this.toScaledViewportDimension(aNewValue.doubleValue(), FxCheckerboardViewerImpl.this.getViewportWidth(), FxCheckerboardViewerImpl.this.getFieldWidth(), FxCheckerboardViewerImpl.this.getFieldGap(), FxCheckerboardViewerImpl.this._bordersH + FxCheckerboardViewerImpl.this._windowDecorationH);
                        if (theNewViewportWidth == -1) break;
                        LOGGER.debug("Viewport width changed to := " + theNewViewportWidth);
                        FxCheckerboardViewerImpl.this.setViewportWidth(theNewViewportWidth);
                        break;
                    }
                    case SCALE_FIELDS: {
                        int theNewFieldWidth = ResizeEventHandler.this.toScaledFieldDimension(aNewValue.doubleValue(), FxCheckerboardViewerImpl.this.getViewportWidth(), FxCheckerboardViewerImpl.this.getFieldWidth(), FxCheckerboardViewerImpl.this.getFieldGap(), FxCheckerboardViewerImpl.this._bordersH + FxCheckerboardViewerImpl.this._windowDecorationH);
                        if (theNewFieldWidth == -1) break;
                        LOGGER.debug("Field width changed to := " + theNewFieldWidth);
                        FxCheckerboardViewerImpl.this.setFieldWidth(theNewFieldWidth);
                        break;
                    }
                }
            }
        };
        private ChangeListener<Number> _onWindowHeightChangedEventHandler = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number aOldValue, Number aNewValue) {
                FxCheckerboardViewerImpl.this._lastResizeTimeInMs = System.currentTimeMillis();
                if (Math.abs(aNewValue.doubleValue() - aOldValue.doubleValue()) > 10.0) {
                    return;
                }
                if (Double.isNaN(FxCheckerboardViewerImpl.this._bordersV) && !Double.isNaN(aOldValue.doubleValue())) {
                    FxCheckerboardViewerImpl.this.initBordersV(aOldValue.doubleValue());
                    FxCheckerboardViewerImpl.this.initMinStageHeight();
                }
                switch (FxCheckerboardViewerImpl.this.getScaleMode()) {
                    case SCALE_GRID: {
                        int theNewViewportHeight = ResizeEventHandler.this.toScaledViewportDimension(aNewValue.doubleValue(), FxCheckerboardViewerImpl.this.getViewportHeight(), FxCheckerboardViewerImpl.this.getFieldHeight(), FxCheckerboardViewerImpl.this.getFieldGap(), FxCheckerboardViewerImpl.this._bordersV + FxCheckerboardViewerImpl.this._windowDecorationV);
                        if (theNewViewportHeight == -1) break;
                        LOGGER.debug("Viewport height changed to := " + theNewViewportHeight);
                        FxCheckerboardViewerImpl.this.setViewportHeight(theNewViewportHeight);
                        break;
                    }
                    case SCALE_FIELDS: {
                        int theNewFieldHeight = ResizeEventHandler.this.toScaledFieldDimension(aNewValue.doubleValue(), FxCheckerboardViewerImpl.this.getViewportHeight(), FxCheckerboardViewerImpl.this.getFieldHeight(), FxCheckerboardViewerImpl.this.getFieldGap(), FxCheckerboardViewerImpl.this._bordersV + FxCheckerboardViewerImpl.this._windowDecorationV);
                        if (theNewFieldHeight == -1) break;
                        LOGGER.debug("Field height changed to := " + theNewFieldHeight);
                        FxCheckerboardViewerImpl.this.setFieldHeight(theNewFieldHeight);
                        break;
                    }
                }
            }
        };

        public ResizeEventHandler(Stage aWindow) {
            aWindow.widthProperty().addListener(this._onWindowWidthChangedEventHandler);
            aWindow.heightProperty().addListener(this._onWindowHeightChangedEventHandler);
            this._window = aWindow;
        }

        public void dispose() {
            this._window.widthProperty().removeListener(this._onWindowWidthChangedEventHandler);
            this._window.heightProperty().removeListener(this._onWindowHeightChangedEventHandler);
            this._window = null;
        }

        private int toScaledViewportDimension(double aNewWindowDim, int aViewportDim, int aFieldDim, int aFieldGap, double aBordersDim) {
            if (!Double.isNaN(aBordersDim) && aNewWindowDim != 1.0) {
                double theCheckerboardDim = aNewWindowDim - aBordersDim;
                int theViewportDim = (int)Math.round((theCheckerboardDim -= (double)aFieldGap) / (double)(aFieldDim + aFieldGap));
                if (theViewportDim != aViewportDim) {
                    try {
                        return theViewportDim;
                    }
                    catch (VetoException.VetoRuntimeException e) {
                        FxCheckerboardViewerImpl.this.fxResizeStage();
                    }
                }
            }
            return -1;
        }

        private int toScaledFieldDimension(double aNewWindowDim, int aViewportDim, int aFieldDim, int aFieldGap, double aBordersDim) {
            if (!Double.isNaN(aBordersDim) && aNewWindowDim != 1.0) {
                double theCheckerboardDim = aNewWindowDim - aBordersDim;
                int theFieldDim = (int)Math.round(((theCheckerboardDim -= (double)aFieldGap) - (double)((aViewportDim - 1) * aFieldGap)) / (double)aViewportDim);
                if (theFieldDim != aFieldDim) {
                    try {
                        return theFieldDim;
                    }
                    catch (VetoException.VetoRuntimeException e) {
                        FxCheckerboardViewerImpl.this.fxResizeStage();
                    }
                }
            }
            return -1;
        }
    }

    private class ViewDaemon
    extends TimerTask {
        private ViewDaemon() {
        }

        @Override
        public void run() {
            if (FxCheckerboardViewerImpl.this._stage != null && FxCheckerboardViewerImpl.this._lastResizeTimeInMs != -1L && FxCheckerboardViewerImpl.this._lastResizeTimeInMs + 150L < System.currentTimeMillis()) {
                FxCheckerboardViewerImpl.this._lastResizeTimeInMs = -1L;
                Runnable theRunner = new Runnable(){

                    @Override
                    public void run() {
                        if (Double.isNaN(FxCheckerboardViewerImpl.this._bordersH)) {
                            FxCheckerboardViewerImpl.this.initMinStageWidth();
                        }
                        if (Double.isNaN(FxCheckerboardViewerImpl.this._bordersV)) {
                            FxCheckerboardViewerImpl.this.initMinStageHeight();
                        }
                    }
                };
                if (Platform.isFxApplicationThread()) {
                    theRunner.run();
                } else {
                    Platform.runLater((Runnable)theRunner);
                }
            }
        }
    }
}

