/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard.alt.javafx.impls;

import javafx.scene.Node;
import org.refcodes.checkerboard.alt.javafx.FxCheckerboardViewer;
import org.refcodes.checkerboard.alt.javafx.FxSpriteFactory;

public abstract class AbstractFxSpriteFactory<S, NF extends AbstractFxSpriteFactory<S, NF>>
implements FxSpriteFactory<S> {
    private double _scaleFactor = 1.0;
    private double _opacity = 1.0;

    public double getScaleFactor() {
        return this._scaleFactor;
    }

    public void setScaleFactor(double aScaleFactor) {
        this._scaleFactor = aScaleFactor;
    }

    public NF withScaleFactor(double aScaleFactor) {
        this._scaleFactor = aScaleFactor;
        return (NF)this;
    }

    public double getOpacity() {
        return this._opacity;
    }

    public void setOpacity(double aOpacity) {
        this._opacity = aOpacity;
    }

    public NF withOpacity(double aOpacity) {
        this._opacity = aOpacity;
        return (NF)this;
    }

    protected static double getScaleX(Node aSprite, FxCheckerboardViewer<?, ?> aCheckerboard) {
        return (double)aCheckerboard.getFieldWidth() / aSprite.getBoundsInLocal().getWidth();
    }

    protected static double getScaleY(Node aSprite, FxCheckerboardViewer<?, ?> aCheckerboard) {
        return (double)aCheckerboard.getFieldHeight() / aSprite.getBoundsInLocal().getHeight();
    }

    protected Node initSprite(Node aSprite, FxCheckerboardViewer<?, ?> aCheckerboard) {
        double theScaleX = AbstractFxSpriteFactory.getScaleX(aSprite, aCheckerboard) - (1.0 - this._scaleFactor);
        double theScaleY = AbstractFxSpriteFactory.getScaleY(aSprite, aCheckerboard) - (1.0 - this._scaleFactor);
        aSprite.setScaleX(theScaleX);
        aSprite.setScaleY(theScaleY);
        aSprite.setOpacity(this.getOpacity());
        return aSprite;
    }
}

