package org.refcodes.checkerboard.alt.javafx.impls;

import org.refcodes.checkerboard.alt.javafx.FxCheckerboardViewer;
import org.refcodes.checkerboard.alt.javafx.FxSpriteFactory;

import javafx.scene.Node;

/**
 * A factory for creating AbstractFxSprite objects.
 *
 * @param <S> the generic type
 * @param <NF> the generic type
 */
public abstract class AbstractFxSpriteFactory<S, NF extends AbstractFxSpriteFactory<S, NF>> implements FxSpriteFactory<S> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private double _scaleFactor = 1;

	private double _opacity = 1;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// BUILDER:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Gets the scale factor.
	 *
	 * @return the scale factor
	 */
	public double getScaleFactor() {
		return _scaleFactor;
	}

	/**
	 * Sets the scale factor.
	 *
	 * @param aScaleFactor the new scale factor
	 */
	public void setScaleFactor( double aScaleFactor ) {
		_scaleFactor = aScaleFactor;
	}

	/**
	 * With scale factor.
	 *
	 * @param aScaleFactor the a scale factor
	 * @return the nf
	 */
	@SuppressWarnings("unchecked")
	public NF withScaleFactor( double aScaleFactor ) {
		_scaleFactor = aScaleFactor;
		return (NF) this;
	}

	/**
	 * Gets the opacity.
	 *
	 * @return the opacity
	 */
	public double getOpacity() {
		return _opacity;
	}

	/**
	 * Sets the opacity.
	 *
	 * @param aOpacity the new opacity
	 */
	public void setOpacity( double aOpacity ) {
		_opacity = aOpacity;
	}

	/**
	 * With opacity.
	 *
	 * @param aOpacity the a opacity
	 * @return the nf
	 */
	@SuppressWarnings("unchecked")
	public NF withOpacity( double aOpacity ) {
		_opacity = aOpacity;
		return (NF) this;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Gets the scale X.
	 *
	 * @param aSprite the a sprite
	 * @param aCheckerboard the a checkerboard
	 * @return the scale X
	 */
	protected static double getScaleX( Node aSprite, FxCheckerboardViewer<?, ?> aCheckerboard ) {
		return aCheckerboard.getFieldWidth() / aSprite.getBoundsInLocal().getWidth();
	}

	/**
	 * Gets the scale Y.
	 *
	 * @param aSprite the a sprite
	 * @param aCheckerboard the a checkerboard
	 * @return the scale Y
	 */
	protected static double getScaleY( Node aSprite, FxCheckerboardViewer<?, ?> aCheckerboard ) {
		return aCheckerboard.getFieldHeight() / aSprite.getBoundsInLocal().getHeight();
	}

	/**
	 * Inits the sprite.
	 *
	 * @param aSprite the a sprite
	 * @param aCheckerboard the a checkerboard
	 * @return the node
	 */
	protected Node initSprite( Node aSprite, FxCheckerboardViewer<?, ?> aCheckerboard ) {
		double theScaleX = getScaleX( aSprite, aCheckerboard ) - (1 - _scaleFactor);
		double theScaleY = getScaleY( aSprite, aCheckerboard ) - (1 - _scaleFactor);
		aSprite.setScaleX( theScaleX );
		aSprite.setScaleY( theScaleY );
		aSprite.setOpacity( getOpacity() );
		return aSprite;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
