// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.checkerboard.alt.javafx.impls;

import org.refcodes.checkerboard.BoulderDashStatus;
import org.refcodes.checkerboard.alt.javafx.FxBoulderDashFactory;
import org.refcodes.checkerboard.alt.javafx.FxCheckerboardViewer;
import org.refcodes.data.ext.boulderdash.BoulderDashAnimation;
import org.refcodes.data.ext.boulderdash.BoulderDashAnimationInputStreamsFactory;
import org.refcodes.data.ext.boulderdash.BoulderDashPixmap;
import org.refcodes.data.ext.boulderdash.BoulderDashPixmapInputStreamFactory;
import org.refcodes.data.ext.boulderdash.impls.BoulderDashAnimationInputStreamsFactoryImpl;
import org.refcodes.data.ext.boulderdash.impls.BoulderDashPixmapInputStreamFactoryImpl;
import org.refcodes.graphical.ext.javafx.FxGraphicalUtility;
import org.refcodes.graphical.ext.javafx.impls.FxFlipBookBuilderImpl;

import javafx.scene.Node;
import javafx.scene.image.ImageView;

/**
 * @author steiner
 *
 */
public class FxBoulderDashFactoryImpl extends AbstractFxSpriteFactory<BoulderDashStatus, FxBoulderDashFactoryImpl> implements FxBoulderDashFactory {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	private static final int IMAGE_DURATION = 150;

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private BoulderDashAnimationInputStreamsFactory _animationFactory = new BoulderDashAnimationInputStreamsFactoryImpl();
	private BoulderDashPixmapInputStreamFactory _pixmapFactory = new BoulderDashPixmapInputStreamFactoryImpl();

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public FxBoulderDashFactoryImpl() {}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public Node toInstance( BoulderDashStatus aIdentifier, FxCheckerboardViewer<BoulderDashStatus> aContext ) {
		switch ( aIdentifier ) {
		case AMOEBA: {
			FxFlipBookBuilderImpl theSprite = new FxFlipBookBuilderImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.AMOEBA ) ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case BOULDER:
			return initSprite( new ImageView( FxGraphicalUtility.toImage( _pixmapFactory.toInstance( BoulderDashPixmap.BOULDER ) ) ), aContext );
		case BUTTERFLY: {
			FxFlipBookBuilderImpl theSprite = new FxFlipBookBuilderImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.BUTTERFLY ) ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case DIAMOND: {
			FxFlipBookBuilderImpl theSprite = new FxFlipBookBuilderImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.DIAMOND_BIRTH ) ) );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.DIAMOND ) ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case DIAMOND_BIRTH: {
			FxFlipBookBuilderImpl theSprite = new FxFlipBookBuilderImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.DIAMOND_BIRTH ) ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case DIRT:
			return initSprite( new ImageView( FxGraphicalUtility.toImage( _pixmapFactory.toInstance( BoulderDashPixmap.DIRT ) ) ), aContext );
		case EXPANDING_WALL:
			return initSprite( new ImageView( FxGraphicalUtility.toImage( _pixmapFactory.toInstance( BoulderDashPixmap.EXPANDING_WALL ) ) ), aContext );
		case FIREFLY: {
			FxFlipBookBuilderImpl theSprite = new FxFlipBookBuilderImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.FIREFLY ) ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case MAGIC_WALL: {
			FxFlipBookBuilderImpl theSprite = new FxFlipBookBuilderImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.MAGIC_WALL ) ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case MAGIC_WALL_EXPIRED:
			return initSprite( new ImageView( FxGraphicalUtility.toImage( _pixmapFactory.toInstance( BoulderDashPixmap.MAGIC_WALL_EXPIRED ) ) ), aContext );
		case ROCKFORD_BIRTH: {
			FxFlipBookBuilderImpl theSprite = new FxFlipBookBuilderImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.ROCKFORD_BIRTH ) ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case ROCKFORD_FACING_FORWARD: {
			FxFlipBookBuilderImpl theSprite = new FxFlipBookBuilderImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.STEEL_WALL ) ) );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.STEEL_WALL ) ) );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.STEEL_WALL ) ) );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.ROCKFORD_BIRTH ) ) );
			theSprite.withMainLoopImage( FxGraphicalUtility.toImage( _pixmapFactory.toInstance( BoulderDashPixmap.ROCKFORD_FACING_FORWARD ) ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case ROCKFORD_FACING_FORWARD_BLINKING: {
			FxFlipBookBuilderImpl theSprite = new FxFlipBookBuilderImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.ROCKFORD_FACING_FORWARD_BLINKING ) ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case ROCKFORD_FACING_FORWARD_BLINKING_TRAPPING_FOOT: {
			FxFlipBookBuilderImpl theSprite = new FxFlipBookBuilderImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.ROCKFORD_FACING_FORWARD_BLINKING_TAPPING_FOOT ) ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case ROCKFORD_FACING_FORWARD_TRAPPING_FOOT: {
			FxFlipBookBuilderImpl theSprite = new FxFlipBookBuilderImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withStartUpSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.ROCKFORD_FACING_FORWARD_TAPPING_FOOT ) ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case ROCKFORD_FACING_LEFT: {
			FxFlipBookBuilderImpl theSprite = new FxFlipBookBuilderImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.ROCKFORD_FACING_LEFT ) ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case ROCKFORD_FACING_RIGHT: {
			FxFlipBookBuilderImpl theSprite = new FxFlipBookBuilderImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.ROCKFORD_FACING_RIGHT ) ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case STEEL_WALL:
			return initSprite( new ImageView( FxGraphicalUtility.toImage( _pixmapFactory.toInstance( BoulderDashPixmap.STEEL_WALL ) ) ), aContext );
		case STEEL_WALL_BLINKING: {
			FxFlipBookBuilderImpl theSprite = new FxFlipBookBuilderImpl().withImageDurationInMs( IMAGE_DURATION );
			theSprite.withMainLoopSequence( FxGraphicalUtility.toImages( _animationFactory.toInstance( BoulderDashAnimation.STEEL_WALL ) ) );
			initSprite( theSprite, aContext );
			theSprite.start();
			return theSprite;
		}
		case STEEL_WALL_OPEN:
			return initSprite( new ImageView( FxGraphicalUtility.toImage( _pixmapFactory.toInstance( BoulderDashPixmap.STEEL_WALL_OPEN ) ) ), aContext );
		default:
			return null;
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
