/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard.alt.javafx.impls;

import javafx.application.Application;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import org.refcodes.checkerboard.BackgroundFactory;
import org.refcodes.checkerboard.BoulderDashStatus;
import org.refcodes.checkerboard.ChangePositionEvent;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.SpriteFactory;
import org.refcodes.checkerboard.alt.javafx.FxCheckerboardViewer;
import org.refcodes.checkerboard.alt.javafx.impls.FxBoulderDashFactoryImpl;
import org.refcodes.checkerboard.alt.javafx.impls.FxCheckerboardViewerImpl;
import org.refcodes.checkerboard.alt.javafx.impls.FxChessboardFactoryImpl;
import org.refcodes.checkerboard.impls.CheckerboardImpl;
import org.refcodes.checkerboard.impls.PlayerImpl;
import org.refcodes.component.InitializeException;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.VetoException;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.MoveMode;
import org.refcodes.graphical.ScaleMode;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;

public class BoulderDashDemo
extends Application {
    private static final double SCALE_FACTOR = 1.0;
    private static RuntimeLogger LOGGER = (RuntimeLogger)RuntimeLoggerFactorySingleton.getInstance().createInstance();
    private FxCheckerboardViewerImpl<BoulderDashStatus> _boulderDashViewer = null;
    private Checkerboard<BoulderDashStatus> _boulderDash = null;
    private Player<BoulderDashStatus> _blackRookA = new PlayerImpl(0, 0).withState((Object)BoulderDashStatus.BOULDER);
    private Player<BoulderDashStatus> _blackKnightB = new PlayerImpl(1, 0).withState((Object)BoulderDashStatus.STEEL_WALL);
    private Player<BoulderDashStatus> _blackKing = new PlayerImpl(4, 0).withState((Object)BoulderDashStatus.ROCKFORD_FACING_FORWARD);
    private Player<BoulderDashStatus> _blackKnightG = new PlayerImpl(6, 0).withState((Object)BoulderDashStatus.STEEL_WALL);
    private Player<BoulderDashStatus> _blackRookH = new PlayerImpl(7, 0).withState((Object)BoulderDashStatus.BOULDER);
    private Player<BoulderDashStatus> _whiteRookA = new PlayerImpl(0, 7).withState((Object)BoulderDashStatus.ROCKFORD_FACING_LEFT);
    private Player<BoulderDashStatus> _whiteRookH = new PlayerImpl(7, 7).withState((Object)BoulderDashStatus.ROCKFORD_FACING_FORWARD);
    private Player<BoulderDashStatus> _whitePawnA = new PlayerImpl(0, 6).withState((Object)BoulderDashStatus.BOULDER);
    private Player<BoulderDashStatus> _whitePawnB = new PlayerImpl(1, 6).withState((Object)BoulderDashStatus.BOULDER);
    private Player<BoulderDashStatus> _whitePawnC = new PlayerImpl(2, 6).withState((Object)BoulderDashStatus.DIAMOND);
    private Player<BoulderDashStatus> _whitePawnD = new PlayerImpl(3, 6).withState((Object)BoulderDashStatus.BOULDER);
    private Player<BoulderDashStatus> _whitePawnE = new PlayerImpl(4, 6).withState((Object)BoulderDashStatus.BOULDER);
    private Player<BoulderDashStatus> _whitePawnF = new PlayerImpl(5, 6).withState((Object)BoulderDashStatus.BOULDER);
    private Player<BoulderDashStatus> _whitePawnG = new PlayerImpl(6, 6).withState((Object)BoulderDashStatus.BOULDER);
    private Player<BoulderDashStatus> _whitePawnH = new PlayerImpl(7, 6).withState((Object)BoulderDashStatus.BOULDER);

    private void initializePlayer(Checkerboard<BoulderDashStatus> aCheckerboard) {
        LOGGER.info("Initializing players on boulderDash ...");
        aCheckerboard.putPlayer(this._blackRookA);
        aCheckerboard.putPlayer(this._blackKnightB);
        aCheckerboard.putPlayer(this._blackKnightG);
        aCheckerboard.putPlayer(this._blackRookH);
        aCheckerboard.putPlayer(this._whiteRookA);
        aCheckerboard.putPlayer(this._whiteRookH);
        aCheckerboard.putPlayer(this._whitePawnA);
        aCheckerboard.putPlayer(this._whitePawnB);
        aCheckerboard.putPlayer(this._whitePawnC);
        aCheckerboard.putPlayer(this._whitePawnD);
        aCheckerboard.putPlayer(this._whitePawnE);
        aCheckerboard.putPlayer(this._whitePawnF);
        aCheckerboard.putPlayer(this._whitePawnG);
        aCheckerboard.putPlayer(this._whitePawnH);
    }

    public void start(Stage aPrimaryStage) {
        try {
            aPrimaryStage.setTitle("Checkerboard");
            this._boulderDash = new CheckerboardImpl();
            this._boulderDashViewer = new FxCheckerboardViewerImpl<BoulderDashStatus>(this._boulderDash){

                public void onChangePositionEvent(ChangePositionEvent<BoulderDashStatus> aEvent, Checkerboard<BoulderDashStatus> aSource) throws VetoException {
                    if (aEvent.getPrecedingPosition().getPositionX() == 0 && aEvent.getPrecedingPosition().getPositionY() == 0) {
                        throw new VetoException("Player <" + aEvent.getSource() + "> is glued to position (1, 1).");
                    }
                }
            };
            this._boulderDash.withGridDimension(20, 20);
            this._boulderDash.withGridMode(GridMode.CLOSED);
            ((FxCheckerboardViewer)this._boulderDashViewer.withMoveMode(MoveMode.SMOOTH)).withScaleMode(ScaleMode.SCALE_GRID);
            this._boulderDashViewer.withSpriteFactory((SpriteFactory)new FxBoulderDashFactoryImpl().withScaleFactor(1.0));
            ((FxCheckerboardViewer)((FxCheckerboardViewer)((FxCheckerboardViewer)this._boulderDashViewer.withViewportDimension(16, 16)).withFieldDimension(32, 32)).withFieldGap(2)).withMinViewportDimension(8, 8);
            this._boulderDashViewer.withBackgroundFactory((BackgroundFactory)new FxChessboardFactoryImpl().withFieldGapColor(Color.rgb((int)95, (int)255, (int)0)).withOddFieldColor(Color.rgb((int)0, (int)95, (int)0)).withEvenFieldColor(Color.rgb((int)0, (int)135, (int)0)));
            this._boulderDashViewer.withInitialize(aPrimaryStage).show();
            this._boulderDashViewer.withViewportOffset(0, 0);
            ControlFlowUtility.createExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        BoulderDashDemo.this.initializePlayer((Checkerboard<BoulderDashStatus>)BoulderDashDemo.this._boulderDash);
                        BoulderDashDemo.this._blackRookA.blink();
                        BoulderDashDemo.this.changeOffset();
                        BoulderDashDemo.this.movePlayer();
                        BoulderDashDemo.this.showPlayer();
                        BoulderDashDemo.this.resizeGrid();
                        BoulderDashDemo.this._blackKing.blink();
                        BoulderDashDemo.this._blackKing.show();
                        BoulderDashDemo.this.removePlayer();
                        BoulderDashDemo.this.dragPlayer();
                    }
                    catch (Exception ignore) {
                        LOGGER.error(ExceptionUtility.toMessage((Throwable)ignore), (Throwable)ignore);
                    }
                }
            });
        }
        catch (InitializeException e) {
            LOGGER.error(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
            System.exit(1);
        }
    }

    private void changeOffset() {
        this._boulderDashViewer.setViewportOffset(this._boulderDashViewer.getViewportOffsetX() - 2, this._boulderDashViewer.getViewportOffsetY() - 1);
    }

    private void movePlayer() throws InterruptedException {
        this._whitePawnA.setPosition(this._whitePawnA.getPositionX(), this._whitePawnA.getPositionY() - 2);
        Thread.sleep(500L);
        Thread.sleep(500L);
        this._whitePawnB.setPosition(this._whitePawnB.getPositionX(), this._whitePawnB.getPositionY() - 1);
        Thread.sleep(500L);
        this._blackKnightB.setPosition(this._blackKnightB.getPositionX() + 1, this._blackKnightB.getPositionY() + 2);
        Thread.sleep(500L);
        this._whitePawnC.setPosition(this._whitePawnC.getPositionX(), this._whitePawnC.getPositionY() - 2);
    }

    private void resizeGrid() throws InitializeException, InterruptedException {
        this._boulderDashViewer.withViewportWidth(this._boulderDashViewer.getViewportWidth() + 2);
        Thread.sleep(500L);
        this._boulderDashViewer.withViewportHeight(this._boulderDashViewer.getViewportHeight() + 2);
        Thread.sleep(500L);
        this._boulderDashViewer.withViewportWidth(this._boulderDashViewer.getViewportWidth() + 2);
        Thread.sleep(500L);
        this._boulderDashViewer.withViewportWidth(this._boulderDashViewer.getViewportWidth() - 1);
        Thread.sleep(500L);
        this._boulderDashViewer.withViewportWidth(this._boulderDashViewer.getViewportWidth() - 1);
        Thread.sleep(500L);
        this._boulderDashViewer.withViewportWidth(this._boulderDashViewer.getViewportWidth() - 2);
        this._boulderDashViewer.withViewportHeight(this._boulderDashViewer.getViewportHeight() + 1);
        Thread.sleep(500L);
        this._boulderDashViewer.withViewportHeight(this._boulderDashViewer.getViewportHeight() - 3);
    }

    private void removePlayer() throws InterruptedException {
        this._boulderDash.removePlayer(this._whitePawnA);
        Thread.sleep(500L);
        this._boulderDash.removePlayer(this._whitePawnB);
        Thread.sleep(500L);
        this._boulderDash.removePlayer(this._blackKnightB);
        Thread.sleep(500L);
        this._boulderDash.removePlayer(this._whitePawnC);
    }

    private void showPlayer() throws InterruptedException {
        this._whitePawnA.blink();
    }

    private void dragPlayer() throws InterruptedException {
        this._blackKing.blink();
        this._blackKing.setState((Object)BoulderDashStatus.ROCKFORD_FACING_FORWARD);
        this._blackKing.draggable();
    }

    public void stop() {
        this._boulderDashViewer.destroy();
    }

    public static void main(String[] args) {
        BoulderDashDemo.launch((String[])args);
    }
}

