// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.checkerboard.alt.javafx.impls;

import java.io.IOException;
import java.net.URL;

import org.refcodes.checkerboard.alt.javafx.FxCheckerboardViewer;
import org.refcodes.checkerboard.alt.javafx.FxChessmenFactory;
import org.refcodes.checkerboard.ChessmanStatus;
import org.refcodes.exception.HiddenException;
import org.refcodes.exception.ExceptionUtility;

import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;

/**
 * @author steiner
 *
 */
public class FxChessmenFactoryImpl extends AbstractFxSpriteFactory<ChessmanStatus, FxChessmenFactoryImpl>implements FxChessmenFactory {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public FxChessmenFactoryImpl() {}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public Node createInstance( ChessmanStatus aIdentifier, FxCheckerboardViewer<ChessmanStatus> aContext ) {
		URL theLocation = null;
		switch ( aIdentifier ) {
		case BLACK_BISHOP:
			theLocation = getClass().getResource( "/org/refcodes/data/ext/chess/bdt_bishop_dark_transparent.fxml" );
			break;
		case BLACK_KING:
			theLocation = getClass().getResource( "/org/refcodes/data/ext/chess/kdt_king_dark_transparent.fxml" );
			break;
		case BLACK_KING_KO:
			theLocation = getClass().getResource( "/org/refcodes/data/ext/chess/fdt_king_rotated_dark_transparent.fxml" );
			break;
		case BLACK_KNIGHT:
			theLocation = getClass().getResource( "/org/refcodes/data/ext/chess/ndt_knight_dark_transparent.fxml" );
			break;
		case BLACK_PAWN:
			theLocation = getClass().getResource( "/org/refcodes/data/ext/chess/pdt_pawn_dark_transparent.fxml" );
			break;
		case BLACK_QUEEN:
			theLocation = getClass().getResource( "/org/refcodes/data/ext/chess/qdt_queen_dark_transparent.fxml" );
			break;
		case BLACK_ROOK:
			theLocation = getClass().getResource( "/org/refcodes/data/ext/chess/rdt_rook_dark_transparent.fxml" );
			break;
		case WHITE_BISHOP:
			theLocation = getClass().getResource( "/org/refcodes/data/ext/chess/blt_bishop_light_transparent.fxml" );
			break;
		case WHITE_KING:
			theLocation = getClass().getResource( "/org/refcodes/data/ext/chess/klt_king_light_transparent.fxml" );
			break;
		case WHITE_KING_KO:
			theLocation = getClass().getResource( "/org/refcodes/data/ext/chess/flt_king_rotated_light_transparent.fxml" );
			break;
		case WHITE_KNIGHT:
			theLocation = getClass().getResource( "/org/refcodes/data/ext/chess/nlt_knight_light_transparent.fxml" );
			break;
		case WHITE_PAWN:
			theLocation = getClass().getResource( "/org/refcodes/data/ext/chess/plt_pawn_light_transparent.fxml" );
			break;
		case WHITE_QUEEN:
			theLocation = getClass().getResource( "/org/refcodes/data/ext/chess/qlt_queen_light_transparent.fxml" );
			break;
		case WHITE_ROOK:
			theLocation = getClass().getResource( "/org/refcodes/data/ext/chess/rlt_rook_light_transparent.fxml" );
			break;
		}

		try {
			Node theSprite = FXMLLoader.load( theLocation );
			initSprite( theSprite, aContext );
			Rectangle theRect = new Rectangle( aContext.getFieldWidth(), aContext.getFieldHeight(), Color.TRANSPARENT );
			StackPane thePane = new StackPane( theRect, theSprite );
			StackPane.setAlignment( theSprite, Pos.CENTER );
			thePane.setMaxWidth( aContext.getFieldWidth() );
			thePane.setPrefWidth( aContext.getFieldWidth() );
			thePane.setMinWidth( aContext.getFieldWidth() );
			thePane.setMaxHeight( aContext.getFieldHeight() );
			thePane.setPrefHeight( aContext.getFieldHeight() );
			thePane.setMinHeight( aContext.getFieldHeight() );
			return thePane;

		}
		catch ( IOException e ) {
			throw new HiddenException( ExceptionUtility.toMessage( e ), e );
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
