package org.refcodes.checkerboard.alt.javafx.impls;

import org.refcodes.checkerboard.alt.javafx.FxCheckerboardViewer;
import org.refcodes.checkerboard.alt.javafx.FxSpriteFactory;

import javafx.scene.Node;

public abstract class AbstractFxSpriteFactory<S, NF extends AbstractFxSpriteFactory<S, NF>> implements FxSpriteFactory<S> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private double _scaleFactor = 1;
	private double _opacity = 1;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// BUILDER:
	// /////////////////////////////////////////////////////////////////////////

	public double getScaleFactor() {
		return _scaleFactor;
	}

	public void setScaleFactor( double aScaleFactor ) {
		_scaleFactor = aScaleFactor;
	}

	@SuppressWarnings("unchecked")
	public NF withScaleFactor( double aScaleFactor ) {
		_scaleFactor = aScaleFactor;
		return (NF) this;
	}

	public double getOpacity() {
		return _opacity;
	}

	public void setOpacity( double aOpacity ) {
		_opacity = aOpacity;
	}

	@SuppressWarnings("unchecked")
	public NF withOpacity( double aOpacity ) {
		_opacity = aOpacity;
		return (NF) this;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	protected static double getScaleX( Node aSprite, FxCheckerboardViewer<?> aCheckerboard ) {
		return aCheckerboard.getFieldWidth() / aSprite.getBoundsInLocal().getWidth();
	}

	protected static double getScaleY( Node aSprite, FxCheckerboardViewer<?> aCheckerboard ) {
		return aCheckerboard.getFieldHeight() / aSprite.getBoundsInLocal().getHeight();
	}

	protected Node initSprite( Node aSprite, FxCheckerboardViewer<?> aCheckerboard ) {
		double theScaleX = getScaleX( aSprite, aCheckerboard ) - (1 - _scaleFactor);
		double theScaleY = getScaleY( aSprite, aCheckerboard ) - (1 - _scaleFactor);
		aSprite.setScaleX( theScaleX );
		aSprite.setScaleY( theScaleY );
		aSprite.setOpacity( getOpacity() );
		return aSprite;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
