/*
 * Decompiled with CFR 0.152.
 */
package org.redkangaroo.maven.plugins.rb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.redkangaroo.maven.plugins.HssfUtils;

public abstract class ResourceBundleGeneratorMojo
extends AbstractMojo {
    protected static final String DOT_PROPERTIES = ".properties";
    protected static final String UNDERSCORE = "_";
    private File inputFile;
    private int sheetIndex;
    private int keyColumnIndex;
    private String checkValuePrefix;
    private String emptyValue;
    protected String propertiesFileBaseName;
    protected Map<Locale, Integer> localeToColumnIndex = new HashMap<Locale, Integer>();

    protected abstract String getTargetEncoding();

    protected abstract File getResouceBundleFile(Locale var1) throws IOException;

    protected abstract File getOutputDirectory();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.generatePropertiesFiles();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not generate properties files", (Exception)e);
        }
    }

    protected void generatePropertiesFiles() throws IOException {
        FileInputStream inputStream = new FileInputStream(this.inputFile);
        HSSFWorkbook myWorkBook = HssfUtils.createWorkbook(inputStream);
        HSSFSheet sheet = myWorkBook.getSheetAt(this.sheetIndex);
        List<Locale> locales = this.extractLocales(sheet);
        for (int i = 0; i < locales.size(); ++i) {
            Locale locale = locales.get(i);
            int columnIndex = this.getFirstValueColumnIndex() + i;
            this.localeToColumnIndex.put(locale, columnIndex);
            this.writeKeyValuePairsToFile(sheet, this.getResouceBundleFile(locale), columnIndex, 1);
        }
        this.generateDefaultLocaleResourceBundle(sheet);
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    protected void generateDefaultLocaleResourceBundle(HSSFSheet sheet) throws IOException {
    }

    protected List<Locale> extractLocales(HSSFSheet sheet) {
        String localeStr;
        ArrayList<Locale> locales = new ArrayList<Locale>();
        HSSFRow firstRow = sheet.getRow(0);
        for (int i = this.getFirstValueColumnIndex(); i <= firstRow.getLastCellNum() && !StringUtils.isEmpty((String)(localeStr = HssfUtils.extractCellValue(firstRow.getCell(i)))); ++i) {
            locales.add(LocaleUtils.toLocale((String)localeStr));
        }
        return locales;
    }

    protected void writeKeyValuePairsToFile(HSSFSheet sheet, File resourceBundleFile, int valueColumnIndex, int rowStartIndex) throws IOException {
        LinkedHashMap<String, String> properties = this.extractProperties(sheet, this.keyColumnIndex, valueColumnIndex, rowStartIndex);
        List<String> lines = this.generateLines(properties);
        this.writeLines(resourceBundleFile, lines, this.getTargetEncoding());
    }

    protected void writeLines(File file, List<String> lines, String encoding) throws IOException {
        FileUtils.writeLines((File)file, (String)encoding, lines);
        this.getLog().info((CharSequence)("Properties written in file: " + file.getAbsolutePath()));
    }

    protected List<String> generateLines(LinkedHashMap<String, String> properties) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String key : properties.keySet()) {
            String line = key + "=" + properties.get(key);
            lines.add(line);
        }
        return lines;
    }

    protected LinkedHashMap<String, String> extractProperties(HSSFSheet sheet, int keyColumnIndex, int valueColumnIndex, int rowStartIndex) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int rowIndex = rowStartIndex; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
            HSSFRow row = sheet.getRow(rowIndex);
            String key = HssfUtils.extractCellValue(row.getCell(keyColumnIndex));
            key = StringUtils.trimToNull((String)key);
            String value = HssfUtils.extractCellValue(row.getCell(valueColumnIndex));
            value = StringUtils.removeStart((String)value, (String)this.checkValuePrefix);
            if (StringUtils.equals((String)(value = StringUtils.trimToNull((String)value)), (String)this.emptyValue)) {
                value = "";
            }
            if (key != null && result.containsKey(key)) {
                this.getLog().info((CharSequence)("Skipping duplicate key: " + key));
                continue;
            }
            if (key == null || value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    protected int getFirstValueColumnIndex() {
        return this.keyColumnIndex + 1;
    }

    public void setPropertiesFileBaseName(String propertiesFileBaseName) {
        this.propertiesFileBaseName = propertiesFileBaseName;
    }
}

