/*
 * Decompiled with CFR 0.152.
 */
package org.redkangaroo.maven.plugins.rb;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.redkangaroo.maven.plugins.rb.ResourceBundleGeneratorMojo;

public class JavaResourceBundleGeneratorMojo
extends ResourceBundleGeneratorMojo {
    private String targetEncoding;
    protected File outputDirectory;
    protected boolean includeCountryInFileName;
    protected String defaultLocale;

    @Override
    protected String getTargetEncoding() {
        return this.targetEncoding;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected File getResouceBundleFile(Locale locale) {
        StringBuilder fileName = new StringBuilder(this.propertiesFileBaseName);
        if (locale != null) {
            fileName.append(this.getResouceBundleFileNameSuffix(locale));
        }
        fileName.append(".properties");
        return new File(this.outputDirectory, fileName.toString());
    }

    protected String getResouceBundleFileNameSuffix(Locale locale) {
        StringBuilder suffix = new StringBuilder("_");
        suffix.append(locale.getLanguage());
        if (this.includeCountryInFileName) {
            suffix.append("_").append(locale.getCountry());
        }
        return suffix.toString();
    }

    @Override
    protected void generateDefaultLocaleResourceBundle(HSSFSheet sheet) throws IOException {
        if (StringUtils.isNotBlank((String)this.defaultLocale)) {
            Locale locale = LocaleUtils.toLocale((String)this.defaultLocale);
            int columnIndex = (Integer)this.localeToColumnIndex.get(locale);
            this.writeKeyValuePairsToFile(sheet, this.getResouceBundleFile(null), columnIndex, 1);
        }
    }

    protected boolean isIncludeCountryInFileName() {
        return this.includeCountryInFileName;
    }

    protected void setIncludeCountryInFileName(boolean includeCountryInFileName) {
        this.includeCountryInFileName = includeCountryInFileName;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

