/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.Valve;
import org.apache.catalina.session.ManagerBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.redisson.Redisson;
import org.redisson.api.RMap;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.codec.CompositeCodec;
import org.redisson.config.Config;
import org.redisson.tomcat.AttributeMessage;
import org.redisson.tomcat.AttributeRemoveMessage;
import org.redisson.tomcat.AttributeUpdateMessage;
import org.redisson.tomcat.AttributesClearMessage;
import org.redisson.tomcat.AttributesPutAllMessage;
import org.redisson.tomcat.RedissonSession;
import org.redisson.tomcat.SessionCreatedMessage;
import org.redisson.tomcat.SessionDestroyedMessage;
import org.redisson.tomcat.UpdateValve;

public class RedissonSessionManager
extends ManagerBase {
    private final Log log = LogFactory.getLog(RedissonSessionManager.class);
    private RedissonClient redisson;
    private String configPath;
    private ReadMode readMode = ReadMode.REDIS;
    private UpdateMode updateMode = UpdateMode.DEFAULT;
    private String keyPrefix = "";
    private boolean broadcastSessionEvents = false;
    private final String nodeId = UUID.randomUUID().toString();
    private UpdateValve updateValve;
    private Codec codecToUse;

    public String getNodeId() {
        return this.nodeId;
    }

    public String getUpdateMode() {
        return this.updateMode.toString();
    }

    public void setUpdateMode(String updateMode) {
        this.updateMode = UpdateMode.valueOf(updateMode);
    }

    public boolean isBroadcastSessionEvents() {
        return this.broadcastSessionEvents;
    }

    public void setBroadcastSessionEvents(boolean replicateSessionEvents) {
        this.broadcastSessionEvents = replicateSessionEvents;
    }

    public String getReadMode() {
        return this.readMode.toString();
    }

    public void setReadMode(String readMode) {
        this.readMode = ReadMode.valueOf(readMode);
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public String getName() {
        return RedissonSessionManager.class.getSimpleName();
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public Session createSession(String sessionId) {
        final Session session = super.createSession(sessionId);
        if (this.broadcastSessionEvents) {
            this.getTopic().publish((Object)new SessionCreatedMessage(this.getNodeId(), session.getId()));
            session.addSessionListener(new SessionListener(){

                public void sessionEvent(SessionEvent event) {
                    if (event.getType() == "destroySession") {
                        RedissonSessionManager.this.getTopic().publish((Object)new SessionDestroyedMessage(RedissonSessionManager.this.getNodeId(), session.getId()));
                    }
                }
            });
        }
        return session;
    }

    public RMap<String, Object> getMap(String sessionId) {
        String separator = this.keyPrefix == null || this.keyPrefix.isEmpty() ? "" : ":";
        String name = this.keyPrefix + separator + "redisson:tomcat_session:" + sessionId;
        return this.redisson.getMap(name, (Codec)new CompositeCodec((Codec)StringCodec.INSTANCE, this.codecToUse, this.codecToUse));
    }

    public RTopic getTopic() {
        String separator = this.keyPrefix == null || this.keyPrefix.isEmpty() ? "" : ":";
        String name = this.keyPrefix + separator + "redisson:tomcat_session_updates:" + this.getContext().getName();
        return this.redisson.getTopic(name);
    }

    public Session findSession(String id) throws IOException {
        Session result = super.findSession(id);
        if (result == null) {
            if (id != null) {
                Map<String, Object> attrs = new HashMap();
                try {
                    attrs = this.getMap(id).getAll(RedissonSession.ATTRS);
                }
                catch (Exception e) {
                    this.log.error((Object)("Can't read session object by id: " + id), (Throwable)e);
                }
                if (attrs.isEmpty()) {
                    this.log.info((Object)("Session " + id + " can't be found"));
                    return null;
                }
                RedissonSession session = (RedissonSession)this.createEmptySession();
                session.load(attrs);
                session.setId(id);
                session.access();
                session.endAccess();
                return session;
            }
            return null;
        }
        result.access();
        result.endAccess();
        return result;
    }

    public Session createEmptySession() {
        return new RedissonSession(this, this.readMode, this.updateMode);
    }

    public void remove(Session session, boolean update) {
        super.remove(session, update);
        if (session.getIdInternal() != null) {
            ((RedissonSession)session).delete();
        }
    }

    public void add(Session session) {
        super.add(session);
        ((RedissonSession)session).save();
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        this.redisson = this.buildClient();
        ClassLoader applicationClassLoader = this.getContext().getLoader().getClassLoader() != null ? this.getContext().getLoader().getClassLoader() : (Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : ((Object)((Object)this)).getClass().getClassLoader());
        Codec codec = this.redisson.getConfig().getCodec();
        try {
            this.codecToUse = (Codec)codec.getClass().getConstructor(ClassLoader.class, codec.getClass()).newInstance(applicationClassLoader, codec);
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
        if (this.updateMode == UpdateMode.AFTER_REQUEST) {
            Pipeline pipeline = this.getEngine().getPipeline();
            if (this.updateValve != null) {
                pipeline.removeValve((Valve)this.updateValve);
            }
            this.updateValve = new UpdateValve(this);
            pipeline.addValve((Valve)this.updateValve);
        }
        if (this.readMode == ReadMode.MEMORY || this.broadcastSessionEvents) {
            RTopic updatesTopic = this.getTopic();
            updatesTopic.addListener(AttributeMessage.class, (MessageListener)new MessageListener<AttributeMessage>(){

                public void onMessage(CharSequence channel, AttributeMessage msg) {
                    try {
                        Session s;
                        if (msg.getNodeId().equals(RedissonSessionManager.this.nodeId)) {
                            return;
                        }
                        RedissonSession session = (RedissonSession)RedissonSessionManager.super.findSession(msg.getSessionId());
                        if (session != null) {
                            AttributeMessage m;
                            if (msg instanceof SessionDestroyedMessage) {
                                session.expire();
                            }
                            if (msg instanceof AttributeRemoveMessage) {
                                for (String name : ((AttributeRemoveMessage)msg).getNames()) {
                                    session.superRemoveAttributeInternal(name, true);
                                }
                            }
                            if (msg instanceof AttributesClearMessage) {
                                RedissonSessionManager.super.remove((Session)session, false);
                            }
                            if (msg instanceof AttributesPutAllMessage) {
                                m = (AttributesPutAllMessage)msg;
                                Map<String, Object> attrs = ((AttributesPutAllMessage)m).getAttrs(RedissonSessionManager.this.codecToUse.getMapValueDecoder());
                                session.load(attrs);
                            }
                            if (msg instanceof AttributeUpdateMessage) {
                                m = (AttributeUpdateMessage)msg;
                                session.superSetAttribute(((AttributeUpdateMessage)m).getName(), ((AttributeUpdateMessage)m).getValue(RedissonSessionManager.this.codecToUse.getMapValueDecoder()), true);
                            }
                        } else if (msg instanceof SessionCreatedMessage && (s = RedissonSessionManager.this.findSession(msg.getSessionId())) == null) {
                            throw new IllegalStateException("Unable to find session: " + msg.getSessionId());
                        }
                    }
                    catch (Exception e) {
                        RedissonSessionManager.this.log.error((Object)"Unable to handle topic message", (Throwable)e);
                    }
                }
            });
        }
        this.setState(LifecycleState.STARTING);
    }

    protected RedissonClient buildClient() throws LifecycleException {
        Config config = null;
        try {
            config = Config.fromJSON((File)new File(this.configPath), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (IOException e) {
            try {
                config = Config.fromYAML((File)new File(this.configPath), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (IOException e1) {
                this.log.error((Object)("Can't parse json config " + this.configPath), (Throwable)e);
                throw new LifecycleException("Can't parse yaml config " + this.configPath, (Throwable)e1);
            }
        }
        try {
            return Redisson.create((Config)config);
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
    }

    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.setState(LifecycleState.STOPPING);
        if (this.updateValve != null) {
            this.getEngine().getPipeline().removeValve((Valve)this.updateValve);
            this.updateValve = null;
        }
        this.codecToUse = null;
        try {
            this.shutdownRedisson();
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
    }

    protected void shutdownRedisson() {
        if (this.redisson != null) {
            this.redisson.shutdown();
        }
    }

    public void store(HttpSession session) throws IOException {
        if (session == null) {
            return;
        }
        RedissonSession sess = (RedissonSession)super.findSession(session.getId());
        if (sess != null) {
            sess.access();
            sess.endAccess();
            sess.save();
        }
    }

    public static enum UpdateMode {
        DEFAULT,
        AFTER_REQUEST;

    }

    public static enum ReadMode {
        REDIS,
        MEMORY;

    }
}

