/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.catalina.LifecycleException;
import org.redisson.api.RedissonClient;
import org.redisson.tomcat.RedissonSessionManager;

public class JndiRedissonSessionManager
extends RedissonSessionManager {
    private String jndiName;

    @Override
    public void setConfigPath(String configPath) {
        throw new IllegalArgumentException("configPath is unavaialble for JNDI based manager");
    }

    @Override
    protected RedissonClient buildClient() throws LifecycleException {
        InitialContext context = null;
        try {
            context = new InitialContext();
            Context envCtx = (Context)context.lookup("java:comp/env");
            RedissonClient redissonClient = (RedissonClient)envCtx.lookup(this.jndiName);
            return redissonClient;
        }
        catch (NamingException e) {
            throw new LifecycleException("Unable to locate Redisson instance by name: " + this.jndiName, (Throwable)e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    throw new LifecycleException("Unable to close JNDI context", (Throwable)e);
                }
            }
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }
}

