/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.redisson.tomcat.RedissonSessionManager;

public class UpdateValve
extends ValveBase {
    private final RedissonSessionManager manager;

    public UpdateValve(RedissonSessionManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        String sessionId = request.getRequestedSessionId();
        Session session = request.getContext().getManager().findSession(sessionId);
        if (session != null) {
            if (!session.isValid()) {
                session.expire();
                request.getContext().getManager().remove(session);
            } else {
                this.manager.add(session);
                session.access();
                session.endAccess();
            }
        }
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            this.manager.store(request.getSession(false));
        }
    }
}

