/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.tomcat;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import java.io.IOException;
import java.security.Principal;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.tomcat.util.res.StringManager;
import org.redisson.tomcat.RedissonSessionManager;

public class RedissonSingleSignOn
extends SingleSignOn {
    private static final StringManager sm = StringManager.getManager(RedissonSingleSignOn.class);
    private static final String SSO_SESSION_ENTRIES = "redisson:tomcat_sso";
    private RedissonSessionManager manager;

    void setSessionManager(RedissonSessionManager manager) {
        if (this.containerLog != null && this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("redissonSingleSignOn.trace.setSessionManager", new Object[]{manager}));
        }
        this.manager = manager;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry ssoEntry;
        String ssoSessionId;
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("redissonSingleSignOn.trace.invoke"));
        }
        if ((ssoSessionId = this.getSsoSessionId(request)) != null && (ssoEntry = this.getSsoEntry(ssoSessionId)) != null) {
            this.cache.put(ssoSessionId, ssoEntry);
        }
        super.invoke(request, response);
    }

    public void sessionDestroyed(String ssoId, Session session) {
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("redissonSingleSignOn.trace.sessionDestroyed"));
        }
        super.sessionDestroyed(ssoId, session);
        this.manager.getMap(SSO_SESSION_ENTRIES).fastRemove((Object[])new String[]{ssoId});
    }

    protected boolean associate(String ssoId, Session session) {
        boolean associated;
        SingleSignOnEntry sso;
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("redissonSingleSignOn.trace.associate", new Object[]{ssoId, session}));
        }
        if ((sso = this.getSsoEntry(ssoId)) != null) {
            this.cache.put(ssoId, sso);
        }
        if (associated = super.associate(ssoId, session)) {
            this.manager.getMap(SSO_SESSION_ENTRIES).fastPut((Object)ssoId, (Object)sso);
        }
        return associated;
    }

    protected boolean reauthenticate(String ssoId, Realm realm, Request request) {
        SingleSignOnEntry sso;
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("redissonSingleSignOn.trace.reauthenticate"));
        }
        if ((sso = this.getSsoEntry(ssoId)) != null) {
            this.cache.put(ssoId, sso);
        }
        return super.reauthenticate(ssoId, realm, request);
    }

    protected void register(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("redissonSingleSignOn.trace.register"));
        }
        super.register(ssoId, principal, authType, username, password);
        this.manager.getMap(SSO_SESSION_ENTRIES).fastPut((Object)ssoId, this.cache.get(ssoId));
    }

    protected void deregister(String ssoId) {
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("redissonSingleSignOn.trace.deregister"));
        }
        super.deregister(ssoId);
        this.manager.getMap(SSO_SESSION_ENTRIES).fastRemove((Object[])new String[]{ssoId});
    }

    protected boolean update(String ssoId, Principal principal, String authType, String username, String password) {
        boolean updated;
        SingleSignOnEntry sso;
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("redissonSingleSignOn.trace.update"));
        }
        if ((sso = this.getSsoEntry(ssoId)) != null) {
            this.cache.put(ssoId, sso);
        }
        if (updated = super.update(ssoId, principal, authType, username, password)) {
            this.manager.getMap(SSO_SESSION_ENTRIES).fastPut((Object)ssoId, (Object)sso);
        }
        return updated;
    }

    protected void removeSession(String ssoId, Session session) {
        SingleSignOnEntry sso;
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("redissonSingleSignOn.trace.removeSession", new Object[]{session, ssoId}));
        }
        if ((sso = this.getSsoEntry(ssoId)) == null) {
            return;
        }
        this.cache.put(ssoId, sso);
        super.removeSession(ssoId, session);
        if (sso.findSessions().isEmpty()) {
            this.deregister(ssoId);
        }
    }

    private SingleSignOnEntry getSsoEntry(String ssoSessionId) {
        SingleSignOnEntry entry;
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("redissonSingleSignOn.trace.getSsoEntry", new Object[]{ssoSessionId}));
        }
        if ((entry = (SingleSignOnEntry)this.manager.getMap(SSO_SESSION_ENTRIES).get((Object)ssoSessionId)) != null) {
            this.cache.put(ssoSessionId, entry);
        }
        return entry;
    }

    private String getSsoSessionId(Request request) {
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("redissonSingleSignOn.trace.getSsoSessionId", new Object[]{request.getRequestURI()}));
        }
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie value : cookies) {
                if (!this.getCookieName().equals(value.getName())) continue;
                cookie = value;
                break;
            }
        }
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }
}

