/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.transaction;

import java.util.concurrent.TimeUnit;
import org.redisson.api.RTransaction;
import org.redisson.api.RedissonClient;
import org.redisson.api.TransactionOptions;
import org.redisson.spring.transaction.RedissonTransactionHolder;
import org.redisson.spring.transaction.RedissonTransactionObject;
import org.redisson.transaction.TransactionException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class RedissonTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager {
    private static final long serialVersionUID = -6151310954082124041L;
    private RedissonClient redisson;

    public RedissonTransactionManager(RedissonClient redisson) {
        this.redisson = redisson;
    }

    public RTransaction getCurrentTransaction() {
        RedissonTransactionHolder to = (RedissonTransactionHolder)TransactionSynchronizationManager.getResource((Object)this.redisson);
        if (to == null) {
            throw new NoTransactionException("No transaction is available for the current thread");
        }
        return to.getTransaction();
    }

    protected Object doGetTransaction() throws org.springframework.transaction.TransactionException {
        RedissonTransactionObject transactionObject = new RedissonTransactionObject();
        RedissonTransactionHolder holder = (RedissonTransactionHolder)TransactionSynchronizationManager.getResource((Object)this.redisson);
        if (holder != null) {
            transactionObject.setTransactionHolder(holder);
        }
        return transactionObject;
    }

    protected boolean isExistingTransaction(Object transaction) throws org.springframework.transaction.TransactionException {
        RedissonTransactionObject transactionObject = (RedissonTransactionObject)transaction;
        return transactionObject.getTransactionHolder() != null;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws org.springframework.transaction.TransactionException {
        RedissonTransactionObject tObject = (RedissonTransactionObject)transaction;
        if (tObject.getTransactionHolder() == null) {
            int timeout = this.determineTimeout(definition);
            TransactionOptions options = TransactionOptions.defaults();
            if (timeout != -1) {
                options.timeout((long)timeout, TimeUnit.SECONDS);
            }
            RTransaction trans = this.redisson.createTransaction(options);
            RedissonTransactionHolder holder = new RedissonTransactionHolder();
            holder.setTransaction(trans);
            tObject.setTransactionHolder(holder);
            TransactionSynchronizationManager.bindResource((Object)this.redisson, (Object)holder);
        }
    }

    protected void doCommit(DefaultTransactionStatus status) throws org.springframework.transaction.TransactionException {
        RedissonTransactionObject to = (RedissonTransactionObject)status.getTransaction();
        try {
            to.getTransactionHolder().getTransaction().commit();
        }
        catch (TransactionException e) {
            throw new TransactionSystemException("Unable to commit transaction", (Throwable)e);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) throws org.springframework.transaction.TransactionException {
        RedissonTransactionObject to = (RedissonTransactionObject)status.getTransaction();
        try {
            to.getTransactionHolder().getTransaction().rollback();
        }
        catch (TransactionException e) {
            throw new TransactionSystemException("Unable to rollback transaction", (Throwable)e);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws org.springframework.transaction.TransactionException {
        RedissonTransactionObject to = (RedissonTransactionObject)status.getTransaction();
        to.setRollbackOnly(true);
    }

    protected void doResume(Object transaction, Object suspendedResources) throws org.springframework.transaction.TransactionException {
        TransactionSynchronizationManager.bindResource((Object)this.redisson, (Object)suspendedResources);
    }

    protected Object doSuspend(Object transaction) throws org.springframework.transaction.TransactionException {
        RedissonTransactionObject to = (RedissonTransactionObject)transaction;
        to.setTransactionHolder(null);
        return TransactionSynchronizationManager.unbindResource((Object)this.redisson);
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.redisson);
        RedissonTransactionObject to = (RedissonTransactionObject)transaction;
        to.getTransactionHolder().setTransaction(null);
    }

    public Object getResourceFactory() {
        return this.redisson;
    }
}

