/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.transaction;

import java.util.concurrent.TimeUnit;
import org.redisson.api.RTransactionReactive;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.api.TransactionOptions;
import org.redisson.spring.transaction.ReactiveRedissonResourceHolder;
import org.redisson.spring.transaction.ReactiveRedissonTransactionObject;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.reactive.AbstractReactiveTransactionManager;
import org.springframework.transaction.reactive.GenericReactiveTransaction;
import org.springframework.transaction.reactive.TransactionSynchronizationManager;
import reactor.core.publisher.Mono;

public class ReactiveRedissonTransactionManager
extends AbstractReactiveTransactionManager {
    private final RedissonReactiveClient redissonClient;

    public ReactiveRedissonTransactionManager(RedissonReactiveClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public Mono<RTransactionReactive> getCurrentTransaction() {
        return TransactionSynchronizationManager.forCurrentTransaction().map(manager -> {
            ReactiveRedissonResourceHolder holder = (ReactiveRedissonResourceHolder)((Object)((Object)manager.getResource((Object)this.redissonClient)));
            if (holder == null) {
                throw new NoTransactionException("No transaction is available for the current thread");
            }
            return holder.getTransaction();
        });
    }

    protected Object doGetTransaction(TransactionSynchronizationManager synchronizationManager) throws TransactionException {
        ReactiveRedissonTransactionObject transactionObject = new ReactiveRedissonTransactionObject();
        ReactiveRedissonResourceHolder holder = (ReactiveRedissonResourceHolder)((Object)synchronizationManager.getResource((Object)this.redissonClient));
        transactionObject.setResourceHolder(holder);
        return transactionObject;
    }

    protected Mono<Void> doBegin(TransactionSynchronizationManager synchronizationManager, Object transaction, TransactionDefinition definition) throws TransactionException {
        ReactiveRedissonTransactionObject tObject = (ReactiveRedissonTransactionObject)transaction;
        TransactionOptions options = TransactionOptions.defaults();
        if (definition.getTimeout() != -1) {
            options.timeout((long)definition.getTimeout(), TimeUnit.SECONDS);
        }
        RTransactionReactive trans = this.redissonClient.createTransaction(options);
        ReactiveRedissonResourceHolder holder = new ReactiveRedissonResourceHolder();
        holder.setTransaction(trans);
        tObject.setResourceHolder(holder);
        synchronizationManager.bindResource((Object)this.redissonClient, (Object)holder);
        return Mono.empty();
    }

    protected Mono<Void> doCommit(TransactionSynchronizationManager synchronizationManager, GenericReactiveTransaction status) throws TransactionException {
        ReactiveRedissonTransactionObject to = (ReactiveRedissonTransactionObject)status.getTransaction();
        return to.getResourceHolder().getTransaction().commit().onErrorMap(ex -> new TransactionSystemException("Unable to commit transaction " + to.getResourceHolder().getTransaction(), ex));
    }

    protected Mono<Void> doRollback(TransactionSynchronizationManager synchronizationManager, GenericReactiveTransaction status) throws TransactionException {
        ReactiveRedissonTransactionObject to = (ReactiveRedissonTransactionObject)status.getTransaction();
        return to.getResourceHolder().getTransaction().rollback().onErrorMap(ex -> new TransactionSystemException("Unable to rollback transaction", ex));
    }

    protected Mono<Object> doSuspend(TransactionSynchronizationManager synchronizationManager, Object transaction) throws TransactionException {
        return Mono.fromSupplier(() -> {
            ReactiveRedissonTransactionObject to = (ReactiveRedissonTransactionObject)transaction;
            to.setResourceHolder(null);
            return synchronizationManager.unbindResource((Object)this.redissonClient);
        });
    }

    protected Mono<Void> doResume(TransactionSynchronizationManager synchronizationManager, Object transaction, Object suspendedResources) throws TransactionException {
        return Mono.fromRunnable(() -> synchronizationManager.bindResource((Object)this.redissonClient, suspendedResources));
    }

    protected Mono<Void> doSetRollbackOnly(TransactionSynchronizationManager synchronizationManager, GenericReactiveTransaction status) throws TransactionException {
        return Mono.fromRunnable(() -> {
            ReactiveRedissonTransactionObject to = (ReactiveRedissonTransactionObject)status.getTransaction();
            to.getResourceHolder().setRollbackOnly();
        });
    }

    protected Mono<Void> doCleanupAfterCompletion(TransactionSynchronizationManager synchronizationManager, Object transaction) {
        return Mono.fromRunnable(() -> {
            synchronizationManager.unbindResource((Object)this.redissonClient);
            ReactiveRedissonTransactionObject to = (ReactiveRedissonTransactionObject)transaction;
            to.getResourceHolder().setTransaction(null);
        });
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        ReactiveRedissonTransactionObject transactionObject = (ReactiveRedissonTransactionObject)transaction;
        return transactionObject.getResourceHolder() != null;
    }
}

