/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.misc.RedisURI;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisNode;

public class RedisClusterNodeDecoder
implements Decoder<List<RedisClusterNode>> {
    public List<RedisClusterNode> decode(ByteBuf buf, State state) throws IOException {
        String response = buf.toString(CharsetUtil.UTF_8);
        ArrayList<RedisClusterNode> nodes = new ArrayList<RedisClusterNode>();
        for (String nodeInfo : response.split("\n")) {
            String masterId;
            String[] params = nodeInfo.split(" ");
            String nodeId = params[0];
            String flagsStr = params[2];
            EnumSet<RedisClusterNode.Flag> flags = EnumSet.noneOf(RedisClusterNode.Flag.class);
            for (String flag : flagsStr.split(",")) {
                String flagValue = flag.replace("slave", "replica").toUpperCase(Locale.ENGLISH).replaceAll("\\?", "");
                flags.add(RedisClusterNode.Flag.valueOf((String)flagValue));
            }
            RedisURI address = null;
            if (!flags.contains(RedisClusterNode.Flag.NOADDR)) {
                String addr = params[1].split("@")[0];
                address = new RedisURI("redis://" + addr);
            }
            if ("-".equals(masterId = params[3])) {
                masterId = null;
            }
            HashSet<Integer> slotsCollection = new HashSet<Integer>();
            RedisClusterNode.LinkState linkState = null;
            if (params.length >= 8 && params[7] != null) {
                linkState = RedisClusterNode.LinkState.valueOf((String)params[7].toUpperCase(Locale.ENGLISH));
            }
            if (params.length > 8) {
                for (int i = 0; i < params.length - 8; ++i) {
                    String slots = params[i + 8];
                    if (slots.indexOf("-<-") != -1 || slots.indexOf("->-") != -1) continue;
                    String[] parts = slots.split("-");
                    if (parts.length == 1) {
                        slotsCollection.add(Integer.valueOf(parts[0]));
                        continue;
                    }
                    if (parts.length != 2) continue;
                    for (int j = Integer.valueOf(parts[0]).intValue(); j < Integer.valueOf(parts[1]) + 1; ++j) {
                        slotsCollection.add(j);
                    }
                }
            }
            RedisNode.NodeType type = null;
            if (flags.contains(RedisClusterNode.Flag.MASTER)) {
                type = RedisNode.NodeType.MASTER;
            } else if (flags.contains(RedisClusterNode.Flag.REPLICA)) {
                type = RedisNode.NodeType.REPLICA;
            }
            RedisClusterNode.RedisClusterNodeBuilder builder = RedisClusterNode.newRedisClusterNode().linkState(linkState).replicaOf(masterId).serving(new RedisClusterNode.SlotRange(slotsCollection)).withId(nodeId).promotedAs(type).withFlags(flags);
            if (address != null) {
                builder.listeningAt(address.getHost(), address.getPort());
            }
            nodes.add(builder.build());
        }
        return nodes;
    }
}

