/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.redisson.api.RFuture;
import org.redisson.api.RScript;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.BinaryConvertor;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.redis.connection.ReactiveScriptingCommands;
import org.springframework.data.redis.connection.ReturnType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveScriptingCommands
extends RedissonBaseReactive
implements ReactiveScriptingCommands {
    RedissonReactiveScriptingCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Mono<String> scriptFlush() {
        return this.executorService.reactive(() -> {
            RFuture f = this.executorService.writeAllVoidAsync((RedisCommand)RedisCommands.SCRIPT_FLUSH, new Object[0]);
            return this.toStringFuture((RFuture<Void>)f);
        });
    }

    public Mono<String> scriptKill() {
        throw new UnsupportedOperationException();
    }

    public Mono<String> scriptLoad(ByteBuffer script) {
        return this.executorService.reactive(() -> {
            List futures = this.executorService.executeAllAsync((RedisCommand)RedisCommands.SCRIPT_LOAD, new Object[]{RedissonReactiveScriptingCommands.toByteArray(script)});
            CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            CompletionStage s = f.thenApply(r -> ((CompletableFuture)futures.get(0)).getNow(null));
            return new CompletableFutureWrapper((CompletableFuture)s);
        });
    }

    public Flux<Boolean> scriptExists(List<String> scriptShas) {
        Mono m = this.executorService.reactive(() -> {
            List futures = this.executorService.writeAllAsync((RedisCommand)RedisCommands.SCRIPT_EXISTS, scriptShas.toArray());
            CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            CompletionStage s = f.thenApply(r -> {
                List result = ((CompletableFuture)futures.get(0)).getNow(new ArrayList());
                for (CompletableFuture future : futures.subList(1, futures.size())) {
                    List l = future.getNow(new ArrayList());
                    for (int i = 0; i < l.size(); ++i) {
                        result.set(i, (Boolean)result.get(i) | (Boolean)l.get(i));
                    }
                }
                return result;
            });
            return new CompletableFutureWrapper((CompletableFuture)s);
        });
        return m.flatMapMany(v -> Flux.fromIterable((Iterable)v));
    }

    protected RedisCommand<?> toCommand(ReturnType returnType, String name) {
        RedisCommand c = null;
        if (returnType == ReturnType.BOOLEAN) {
            c = RScript.ReturnType.BOOLEAN.getCommand();
        } else if (returnType == ReturnType.INTEGER) {
            c = RScript.ReturnType.INTEGER.getCommand();
        } else {
            if (returnType == ReturnType.MULTI) {
                c = RScript.ReturnType.MULTI.getCommand();
                return new RedisCommand(c, name, (Convertor)new BinaryConvertor());
            }
            if (returnType == ReturnType.STATUS) {
                c = RScript.ReturnType.STATUS.getCommand();
            } else if (returnType == ReturnType.VALUE) {
                c = RScript.ReturnType.VALUE.getCommand();
                return new RedisCommand(c, name, (Convertor)new BinaryConvertor());
            }
        }
        return new RedisCommand(c, name);
    }

    public <T> Flux<T> eval(ByteBuffer script, ReturnType returnType, int numKeys, ByteBuffer ... keysAndArgs) {
        RedisCommand<?> c = this.toCommand(returnType, "EVAL");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(RedissonReactiveScriptingCommands.toByteArray(script));
        params.add(numKeys);
        params.addAll(Arrays.stream(keysAndArgs).map(m -> RedissonReactiveScriptingCommands.toByteArray(m)).collect(Collectors.toList()));
        Mono m2 = this.write(null, (Codec)ByteArrayCodec.INSTANCE, c, params.toArray());
        return this.convert(m2);
    }

    protected <T> Flux<T> convert(Mono<T> m) {
        return m.map(e -> {
            if (e.getClass().isArray()) {
                return ByteBuffer.wrap((byte[])e);
            }
            if (e instanceof List && ((List)e).get(0).getClass().isArray()) {
                return ((List)e).stream().map(v -> ByteBuffer.wrap(v)).collect(Collectors.toList());
            }
            return e;
        }).flux();
    }

    public <T> Flux<T> evalSha(String scriptSha, ReturnType returnType, int numKeys, ByteBuffer ... keysAndArgs) {
        RedisCommand<?> c = this.toCommand(returnType, "EVALSHA");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(scriptSha);
        params.add(numKeys);
        params.addAll(Arrays.stream(keysAndArgs).map(m -> RedissonReactiveScriptingCommands.toByteArray(m)).collect(Collectors.toList()));
        Mono m2 = this.write(null, (Codec)ByteArrayCodec.INSTANCE, c, params.toArray());
        return this.convert(m2);
    }
}

