/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.decoder.CodecDecoder;
import org.redisson.client.protocol.decoder.GeoDistanceDecoder;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.ByteBufferGeoResultsDecoder;
import org.redisson.spring.data.connection.DistanceConvertor;
import org.redisson.spring.data.connection.GeoResultsDecoder;
import org.redisson.spring.data.connection.ObjectListReplayDecoder2;
import org.redisson.spring.data.connection.PointDecoder;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.ReactiveGeoCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveGeoCommands
extends RedissonBaseReactive
implements ReactiveGeoCommands {
    private static final RedisCommand<List<Object>> GEOHASH = new RedisCommand("GEOHASH", (MultiDecoder)new ObjectListReplayDecoder());
    private final MultiDecoder<Map<Object, Object>> geoDecoder = new ListMultiDecoder2(new MultiDecoder[]{new ObjectListReplayDecoder2(), new PointDecoder()});
    private final MultiDecoder<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> postitionDecoder = new ListMultiDecoder2(new MultiDecoder[]{new GeoResultsDecoder(), new CodecDecoder(), new PointDecoder(), new ObjectListReplayDecoder()});

    RedissonReactiveGeoCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveGeoCommands.GeoAddCommand, Long>> geoAdd(Publisher<ReactiveGeoCommands.GeoAddCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getGeoLocations(), (String)"Locations must not be null!");
            byte[] keyBuf = RedissonReactiveGeoCommands.toByteArray(command.getKey());
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(keyBuf);
            for (RedisGeoCommands.GeoLocation location : command.getGeoLocations()) {
                args.add(location.getPoint().getX());
                args.add(location.getPoint().getY());
                args.add(RedissonReactiveGeoCommands.toByteArray((ByteBuffer)location.getName()));
            }
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.GEOADD, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoDistCommand, Distance>> geoDist(Publisher<ReactiveGeoCommands.GeoDistCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getFrom(), (String)"From member must not be null!");
            Assert.notNull((Object)command.getTo(), (String)"To member must not be null!");
            byte[] keyBuf = RedissonReactiveGeoCommands.toByteArray(command.getKey());
            byte[] fromBuf = RedissonReactiveGeoCommands.toByteArray(command.getFrom());
            byte[] toBuf = RedissonReactiveGeoCommands.toByteArray(command.getTo());
            RedisGeoCommands.DistanceUnit metric = RedisGeoCommands.DistanceUnit.METERS;
            if (command.getMetric().isPresent()) {
                metric = (Metric)command.getMetric().get();
            }
            Mono m = this.write(keyBuf, (Codec)DoubleCodec.INSTANCE, new RedisCommand("GEODIST", (Convertor)new DistanceConvertor((Metric)metric)), keyBuf, fromBuf, toBuf, metric.getAbbreviation());
            return m.map(v -> new ReactiveRedisConnection.CommandResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveGeoCommands.GeoHashCommand, String>> geoHash(Publisher<ReactiveGeoCommands.GeoHashCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getMembers(), (String)"Members must not be null!");
            byte[] keyBuf = RedissonReactiveGeoCommands.toByteArray(command.getKey());
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getMembers().size() + 1);
            args.add(keyBuf);
            args.addAll(command.getMembers().stream().map(buf -> RedissonReactiveGeoCommands.toByteArray(buf)).collect(Collectors.toList()));
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, GEOHASH, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.MultiValueResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveGeoCommands.GeoPosCommand, Point>> geoPos(Publisher<ReactiveGeoCommands.GeoPosCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getMembers(), (String)"Members must not be null!");
            RedisCommand cmd = new RedisCommand("GEOPOS", this.geoDecoder);
            byte[] keyBuf = RedissonReactiveGeoCommands.toByteArray(command.getKey());
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getMembers().size() + 1);
            args.add(keyBuf);
            args.addAll(command.getMembers().stream().map(buf -> RedissonReactiveGeoCommands.toByteArray(buf)).collect(Collectors.toList()));
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, cmd, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.MultiValueResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoRadiusCommand, Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>>>> geoRadius(Publisher<ReactiveGeoCommands.GeoRadiusCommand> commands) {
        return this.execute(commands, command -> {
            RedisCommand cmd;
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getPoint(), (String)"Point must not be null!");
            Assert.notNull((Object)command.getDistance(), (String)"Distance must not be null!");
            RedisGeoCommands.GeoRadiusCommandArgs args = command.getArgs().orElse(RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs());
            byte[] keyBuf = RedissonReactiveGeoCommands.toByteArray(command.getKey());
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(keyBuf);
            params.add(BigDecimal.valueOf(command.getPoint().getX()).toPlainString());
            params.add(BigDecimal.valueOf(command.getPoint().getY()).toPlainString());
            params.add(command.getDistance().getValue());
            params.add(command.getDistance().getMetric().getAbbreviation());
            if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
                cmd = new RedisCommand("GEORADIUS", this.postitionDecoder);
                params.add("WITHCOORD");
            } else {
                ListMultiDecoder2 distanceDecoder = new ListMultiDecoder2(new MultiDecoder[]{new ByteBufferGeoResultsDecoder(command.getDistance().getMetric()), new GeoDistanceDecoder()});
                cmd = new RedisCommand("GEORADIUS", (MultiDecoder)distanceDecoder);
                params.add("WITHDIST");
            }
            if (args.getLimit() != null) {
                params.add("COUNT");
                params.add(args.getLimit());
            }
            if (args.getSortDirection() != null) {
                params.add(args.getSortDirection().name());
            }
            Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, cmd, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.CommandResponse(command, (Object)Flux.fromIterable((Iterable)v.getContent())));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoRadiusByMemberCommand, Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>>>> geoRadiusByMember(Publisher<ReactiveGeoCommands.GeoRadiusByMemberCommand> commands) {
        return this.execute(commands, command -> {
            RedisCommand cmd;
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getMember(), (String)"Member must not be null!");
            Assert.notNull((Object)command.getDistance(), (String)"Distance must not be null!");
            RedisGeoCommands.GeoRadiusCommandArgs args = command.getArgs().orElse(RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs());
            byte[] keyBuf = RedissonReactiveGeoCommands.toByteArray(command.getKey());
            byte[] memberBuf = RedissonReactiveGeoCommands.toByteArray(command.getMember());
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(keyBuf);
            params.add(memberBuf);
            params.add(command.getDistance().getValue());
            params.add(command.getDistance().getMetric().getAbbreviation());
            if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
                cmd = new RedisCommand("GEORADIUSBYMEMBER", this.postitionDecoder);
                params.add("WITHCOORD");
            } else {
                ListMultiDecoder2 distanceDecoder = new ListMultiDecoder2(new MultiDecoder[]{new ByteBufferGeoResultsDecoder(command.getDistance().getMetric()), new GeoDistanceDecoder()});
                cmd = new RedisCommand("GEORADIUSBYMEMBER", (MultiDecoder)distanceDecoder);
                params.add("WITHDIST");
            }
            if (args.getLimit() != null) {
                params.add("COUNT");
                params.add(args.getLimit());
            }
            if (args.getSortDirection() != null) {
                params.add(args.getSortDirection().name());
            }
            Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, cmd, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.CommandResponse(command, (Object)Flux.fromIterable((Iterable)v.getContent())));
        });
    }
}

