/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.SetReactiveIterator;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveSetCommands;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveSetCommands
extends RedissonBaseReactive
implements ReactiveSetCommands {
    private static final RedisCommand<Long> SADD = new RedisCommand("SADD");
    private static final RedisCommand<Long> SREM = new RedisCommand("SREM");
    private static final RedisStrictCommand<Long> SCARD = new RedisStrictCommand("SCARD");

    RedissonReactiveSetCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SAddCommand, Long>> sAdd(Publisher<ReactiveSetCommands.SAddCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValues(), (String)"Values must not be null!");
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getValues().size() + 1);
            args.add(RedissonReactiveSetCommands.toByteArray(command.getKey()));
            args.addAll(command.getValues().stream().map(v -> RedissonReactiveSetCommands.toByteArray(v)).collect(Collectors.toList()));
            byte[] keyBuf = RedissonReactiveSetCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, SADD, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SRemCommand, Long>> sRem(Publisher<ReactiveSetCommands.SRemCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValues(), (String)"Values must not be null!");
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getValues().size() + 1);
            args.add(RedissonReactiveSetCommands.toByteArray(command.getKey()));
            args.addAll(command.getValues().stream().map(v -> RedissonReactiveSetCommands.toByteArray(v)).collect(Collectors.toList()));
            Mono m = this.write((byte[])args.get(0), (Codec)StringCodec.INSTANCE, SREM, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ByteBuffer> sPop(ReactiveSetCommands.SPopCommand command) {
        Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
        byte[] keyBuf = RedissonReactiveSetCommands.toByteArray(command.getKey());
        Mono m = this.write(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SPOP, keyBuf, command.getCount());
        return m.flatMapMany(v -> Flux.fromIterable((Iterable)v).map(e -> ByteBuffer.wrap(e)));
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>> sPop(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveSetCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SPOP_SINGLE, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse(command, ByteBuffer.wrap(v)));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveSetCommands.SMoveCommand>> sMove(Publisher<ReactiveSetCommands.SMoveCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getDestination(), (String)"Destination key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            byte[] keyBuf = RedissonReactiveSetCommands.toByteArray(command.getKey());
            byte[] destinationBuf = RedissonReactiveSetCommands.toByteArray(command.getDestination());
            byte[] valueBuf = RedissonReactiveSetCommands.toByteArray(command.getValue());
            Mono m = this.write(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SMOVE, keyBuf, destinationBuf, valueBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> sCard(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveSetCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)SCARD, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveSetCommands.SIsMemberCommand>> sIsMember(Publisher<ReactiveSetCommands.SIsMemberCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            byte[] keyBuf = RedissonReactiveSetCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveSetCommands.toByteArray(command.getValue());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, RedisCommands.SISMEMBER, keyBuf, valueBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveSetCommands.SInterCommand, Flux<ByteBuffer>>> sInter(Publisher<ReactiveSetCommands.SInterCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKeys(), (String)"Key must not be null!");
            List list = command.getKeys().stream().map(v -> RedissonReactiveSetCommands.toByteArray(v)).collect(Collectors.toList());
            Mono m = this.write((byte[])list.get(0), (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SINTER, list.toArray());
            return m.map(v -> new ReactiveRedisConnection.CommandResponse(command, (Object)Flux.fromIterable((Iterable)v).map(e -> ByteBuffer.wrap(e))));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SInterStoreCommand, Long>> sInterStore(Publisher<ReactiveSetCommands.SInterStoreCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKeys(), (String)"Keys must not be null!");
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getKeys().size() + 1);
            args.add(RedissonReactiveSetCommands.toByteArray(command.getKey()));
            args.addAll(command.getKeys().stream().map(v -> RedissonReactiveSetCommands.toByteArray(v)).collect(Collectors.toList()));
            Mono m = this.write((byte[])args.get(0), (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.SINTERSTORE, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveSetCommands.SUnionCommand, Flux<ByteBuffer>>> sUnion(Publisher<ReactiveSetCommands.SUnionCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKeys(), (String)"Key must not be null!");
            List list = command.getKeys().stream().map(v -> RedissonReactiveSetCommands.toByteArray(v)).collect(Collectors.toList());
            Mono m = this.write((byte[])list.get(0), (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SUNION, list.toArray());
            return m.map(v -> new ReactiveRedisConnection.CommandResponse(command, (Object)Flux.fromIterable((Iterable)v).map(e -> ByteBuffer.wrap(e))));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SUnionStoreCommand, Long>> sUnionStore(Publisher<ReactiveSetCommands.SUnionStoreCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKeys(), (String)"Keys must not be null!");
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getKeys().size() + 1);
            args.add(RedissonReactiveSetCommands.toByteArray(command.getKey()));
            args.addAll(command.getKeys().stream().map(v -> RedissonReactiveSetCommands.toByteArray(v)).collect(Collectors.toList()));
            Mono m = this.write((byte[])args.get(0), (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.SUNIONSTORE, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveSetCommands.SDiffCommand, Flux<ByteBuffer>>> sDiff(Publisher<ReactiveSetCommands.SDiffCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKeys(), (String)"Key must not be null!");
            List list = command.getKeys().stream().map(v -> RedissonReactiveSetCommands.toByteArray(v)).collect(Collectors.toList());
            Mono m = this.write((byte[])list.get(0), (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SDIFF, list.toArray());
            return m.map(v -> new ReactiveRedisConnection.CommandResponse(command, (Object)Flux.fromIterable((Iterable)v).map(e -> ByteBuffer.wrap(e))));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SDiffStoreCommand, Long>> sDiffStore(Publisher<ReactiveSetCommands.SDiffStoreCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKeys(), (String)"Keys must not be null!");
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getKeys().size() + 1);
            args.add(RedissonReactiveSetCommands.toByteArray(command.getKey()));
            args.addAll(command.getKeys().stream().map(v -> RedissonReactiveSetCommands.toByteArray(v)).collect(Collectors.toList()));
            Mono m = this.write((byte[])args.get(0), (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.SDIFFSTORE, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> sMembers(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveSetCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SMEMBERS, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.CommandResponse(command, (Object)Flux.fromIterable((Iterable)v).map(e -> ByteBuffer.wrap(e))));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> sScan(Publisher<ReactiveRedisConnection.KeyScanCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getOptions(), (String)"ScanOptions must not be null!");
            final byte[] keyBuf = RedissonReactiveSetCommands.toByteArray(command.getKey());
            Flux flux = Flux.create((Consumer)new SetReactiveIterator<byte[]>(){

                protected RFuture<ListScanResult<Object>> scanIterator(RedisClient client, long nextIterPos) {
                    if (command.getOptions().getPattern() == null) {
                        return RedissonReactiveSetCommands.this.executorService.readAsync(client, keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SSCAN, new Object[]{keyBuf, nextIterPos, "COUNT", Optional.ofNullable(command.getOptions().getCount()).orElse(10L)});
                    }
                    return RedissonReactiveSetCommands.this.executorService.readAsync(client, keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SSCAN, new Object[]{keyBuf, nextIterPos, "MATCH", command.getOptions().getPattern(), "COUNT", Optional.ofNullable(command.getOptions().getCount()).orElse(10L)});
                }
            });
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux.map(v -> ByteBuffer.wrap(v))));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveSetCommands.SRandMembersCommand, Flux<ByteBuffer>>> sRandMember(Publisher<ReactiveSetCommands.SRandMembersCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveSetCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SRANDMEMBER, keyBuf, command.getCount().orElse(1L));
            return m.map(v -> new ReactiveRedisConnection.CommandResponse(command, (Object)Flux.fromIterable((Iterable)v).map(e -> ByteBuffer.wrap(e))));
        });
    }
}

