/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.redisson.runtime;

import io.quarkus.cache.redisson.runtime.RedissonCacheInfo;
import io.quarkus.cache.redisson.runtime.RedissonCachesConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RedissonCacheInfoBuilder {
    public static Set<RedissonCacheInfo> build(Set<String> cacheNames, RedissonCachesConfig runtimeConfig) {
        if (cacheNames.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<RedissonCacheInfo> result = new HashSet<RedissonCacheInfo>(cacheNames.size());
        for (String cacheName : cacheNames) {
            RedissonCacheInfo cacheInfo = new RedissonCacheInfo();
            cacheInfo.name = cacheName;
            RedissonCachesConfig.RedissonCacheRuntimeConfig defaultRuntimeConfig = runtimeConfig.defaultConfig();
            RedissonCachesConfig.RedissonCacheRuntimeConfig namedRuntimeConfig = runtimeConfig.cachesConfig().get(cacheInfo.name);
            if (namedRuntimeConfig != null && namedRuntimeConfig.implementation().isPresent()) {
                cacheInfo.implementation = namedRuntimeConfig.implementation();
            } else if (defaultRuntimeConfig.implementation().isPresent()) {
                cacheInfo.implementation = defaultRuntimeConfig.implementation();
            }
            if (namedRuntimeConfig != null && namedRuntimeConfig.expireAfterAccess().isPresent()) {
                cacheInfo.expireAfterAccess = namedRuntimeConfig.expireAfterAccess();
            } else if (defaultRuntimeConfig.expireAfterAccess().isPresent()) {
                cacheInfo.expireAfterAccess = defaultRuntimeConfig.expireAfterAccess();
            }
            if (namedRuntimeConfig != null && namedRuntimeConfig.expireAfterWrite().isPresent()) {
                cacheInfo.expireAfterWrite = namedRuntimeConfig.expireAfterWrite();
            } else if (defaultRuntimeConfig.expireAfterWrite().isPresent()) {
                cacheInfo.expireAfterWrite = defaultRuntimeConfig.expireAfterWrite();
            }
            if (namedRuntimeConfig != null && namedRuntimeConfig.maxSize().isPresent()) {
                cacheInfo.maxSize = namedRuntimeConfig.maxSize();
            } else if (defaultRuntimeConfig.maxSize().isPresent()) {
                cacheInfo.maxSize = defaultRuntimeConfig.maxSize();
            }
            result.add(cacheInfo);
        }
        return result;
    }
}

