/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redisson.client.runtime;

import com.fasterxml.jackson.databind.MapperFeature;
import io.quarkus.arc.DefaultBean;
import io.quarkus.runtime.shutdown.ShutdownConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ConfigSupport;
import org.redisson.config.PropertiesConvertor;

@ApplicationScoped
public class RedissonClientProducer {
    private RedissonClient redisson;
    @Inject
    public ShutdownConfig shutdownConfig;

    @Produces
    @Singleton
    @DefaultBean
    public RedissonClient create() throws IOException {
        String config;
        Optional configFile = ConfigProvider.getConfig().getOptionalValue("quarkus.redisson.file", String.class);
        InputStream configStream = configFile.isPresent() ? this.getClass().getResourceAsStream((String)configFile.get()) : Thread.currentThread().getContextClassLoader().getResourceAsStream("redisson.yaml");
        if (configStream != null) {
            byte[] array = new byte[configStream.available()];
            configStream.read(array);
            config = new String(array, StandardCharsets.UTF_8);
        } else {
            String yaml;
            Stream s = StreamSupport.stream(ConfigProvider.getConfig().getPropertyNames().spliterator(), false);
            config = yaml = PropertiesConvertor.toYaml((String)"quarkus.redisson.", (Iterable)s.sorted().collect(Collectors.toList()), prop -> (String)ConfigProvider.getConfig().getValue(prop, String.class), (boolean)false);
        }
        ConfigSupport support = new ConfigSupport(){
            {
                this.yamlMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
            }
        };
        org.redisson.config.Config c = (org.redisson.config.Config)support.fromYAML(config, org.redisson.config.Config.class);
        this.redisson = Redisson.create((org.redisson.config.Config)c);
        return this.redisson;
    }

    public void setConfig(Config config) {
    }

    @PreDestroy
    public void close() {
        if (this.redisson != null) {
            if (this.shutdownConfig.isShutdownTimeoutSet()) {
                Duration grace = (Duration)this.shutdownConfig.timeout.get();
                this.redisson.shutdown(grace.toMillis(), grace.toMillis() * 2L, TimeUnit.MILLISECONDS);
            } else {
                this.redisson.shutdown();
            }
        }
    }
}

