/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redisson.client.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.redisson.client.deployment.RedissonClientItemBuild;
import io.quarkus.redisson.client.runtime.RedissonClientProducer;
import io.quarkus.redisson.client.runtime.RedissonClientRecorder;
import java.io.IOException;
import org.redisson.RedissonBucket;
import org.redisson.RedissonMultimap;
import org.redisson.RedissonObject;
import org.redisson.api.RBucket;
import org.redisson.api.RExpirable;
import org.redisson.api.RObject;
import org.redisson.api.RObjectReactive;
import org.redisson.codec.Kryo5Codec;
import org.redisson.config.BaseConfig;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.executor.RemoteExecutorService;
import org.redisson.executor.RemoteExecutorServiceAsync;

class QuarkusRedissonClientProcessor {
    private static final String FEATURE = "redisson";

    QuarkusRedissonClientProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem sslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem addProducer() {
        return AdditionalBeanBuildItem.unremovableOf(RedissonClientProducer.class);
    }

    @BuildStep
    void addConfig(BuildProducer<NativeImageResourceBuildItem> nativeResources, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles, BuildProducer<RuntimeInitializedClassBuildItem> staticItems, BuildProducer<ReflectiveClassBuildItem> reflectiveItems) {
        nativeResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"redisson.yaml"}));
        nativeResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.jboss.marshalling.ProviderDescriptor"}));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("redisson.yaml"));
        reflectiveItems.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{Kryo5Codec.class}).methods(false).fields(false).build());
        reflectiveItems.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{RemoteExecutorService.class, RemoteExecutorServiceAsync.class}).methods(true).fields(false).build());
        reflectiveItems.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{Config.class, BaseConfig.class, BaseMasterSlaveServersConfig.class, SingleServerConfig.class, ReplicatedServersConfig.class, SentinelServersConfig.class, ClusterServersConfig.class}).methods(true).fields(true).build());
        reflectiveItems.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{RBucket.class, RedissonBucket.class, RedissonObject.class, RedissonMultimap.class}).methods(true).fields(true).build());
        reflectiveItems.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{RObjectReactive.class, RExpirable.class, RObject.class}).methods(true).build());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    RedissonClientItemBuild build(RedissonClientRecorder recorder) throws IOException {
        recorder.createProducer();
        return new RedissonClientItemBuild();
    }
}

