/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.mybatis;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.redisson.Redisson;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;

public class RedissonCache
implements Cache {
    private String id;
    private RMapCache<Object, Object> mapCache;
    private long timeToLive;
    private long maxIdleTime;
    private int maxSize;

    public RedissonCache(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void putObject(Object o, Object o1) {
        this.check();
        this.mapCache.put(o, o1, this.timeToLive, TimeUnit.MILLISECONDS, this.maxIdleTime, TimeUnit.MILLISECONDS);
    }

    public Object getObject(Object o) {
        this.check();
        return this.mapCache.get(o);
    }

    public Object removeObject(Object o) {
        this.check();
        return this.mapCache.remove(o);
    }

    public void clear() {
        this.check();
        this.mapCache.clear();
    }

    public int getSize() {
        this.check();
        return this.mapCache.size();
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public ReadWriteLock getReadWriteLock() {
        return null;
    }

    public void setRedissonConfig(String config) {
        Config cfg;
        try {
            InputStream is = this.getClass().getResourceAsStream(config);
            cfg = Config.fromYAML((InputStream)is);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't parse config", e);
        }
        RedissonClient redisson = Redisson.create((Config)cfg);
        this.mapCache = this.getMapCache(this.id, redisson);
        if (this.maxSize > 0) {
            this.mapCache.setMaxSize(this.maxSize);
        }
    }

    protected RMapCache<Object, Object> getMapCache(String id, RedissonClient redisson) {
        return redisson.getMapCache(id);
    }

    private void check() {
        if (this.mapCache == null) {
            throw new IllegalStateException("Redisson config is not defined");
        }
    }
}

