/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.micronaut.cache;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Named;
import java.time.Duration;
import org.redisson.api.map.MapLoader;
import org.redisson.api.map.MapWriter;
import org.redisson.api.map.WriteMode;
import org.redisson.api.options.MapCacheOptions;
import org.redisson.api.options.MapOptions;
import org.redisson.api.options.MapParams;
import org.redisson.client.codec.Codec;

public class BaseCacheConfiguration
implements Named {
    MapParams<Object, Object> mapOptions;
    private final String name;
    private Codec codec;
    private Duration expireAfterWrite = Duration.ZERO;
    private Duration expireAfterAccess = Duration.ZERO;
    private int maxSize;

    public BaseCacheConfiguration(String name) {
        this.name = name;
        this.mapOptions = (MapParams)MapOptions.name((String)name);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public void setCodec(String className) {
        this.codec = (Codec)this.create(className);
    }

    private <T> T create(String className) {
        try {
            return (T)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Duration getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public void setExpireAfterWrite(Duration expireAfterWrite) {
        this.expireAfterWrite = expireAfterWrite;
    }

    public Duration getExpireAfterAccess() {
        return this.expireAfterAccess;
    }

    public void setExpireAfterAccess(Duration expireAfterAccess) {
        this.expireAfterAccess = expireAfterAccess;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setWriteBehindBatchSize(int writeBehindBatchSize) {
        this.mapOptions.writeBehindBatchSize(writeBehindBatchSize);
    }

    public void setWriteBehindDelay(int writeBehindDelay) {
        this.mapOptions.writeBehindDelay(writeBehindDelay);
    }

    public void setWriter(String className) {
        this.mapOptions.writer((MapWriter)this.create(className));
    }

    public void setWriteMode(WriteMode writeMode) {
        this.mapOptions.writeMode(writeMode);
    }

    public void setLoader(String className) {
        this.mapOptions.loader((MapLoader)this.create(className));
    }

    public <K, V> MapOptions<K, V> getMapOptions() {
        MapOptions ops = MapOptions.name((String)this.getName());
        ops.writer(this.mapOptions.getWriter());
        ops.writeMode(this.mapOptions.getWriteMode());
        ops.writerAsync(this.mapOptions.getWriterAsync());
        ops.writeBehindDelay(this.mapOptions.getWriteBehindDelay());
        ops.writeBehindBatchSize(this.mapOptions.getWriteBehindBatchSize());
        ops.loader(this.mapOptions.getLoader());
        ops.loaderAsync(this.mapOptions.getLoaderAsync());
        ops.codec((Object)this.getCodec());
        return ops;
    }

    public <K, V> MapCacheOptions<K, V> getMapCacheOptions() {
        MapCacheOptions ops = MapCacheOptions.name((String)this.getName());
        ops.writer(this.mapOptions.getWriter());
        ops.writeMode(this.mapOptions.getWriteMode());
        ops.writerAsync(this.mapOptions.getWriterAsync());
        ops.writeBehindDelay(this.mapOptions.getWriteBehindDelay());
        ops.writeBehindBatchSize(this.mapOptions.getWriteBehindBatchSize());
        ops.loader(this.mapOptions.getLoader());
        ops.loaderAsync(this.mapOptions.getLoaderAsync());
        ops.codec((Object)this.getCodec());
        return ops;
    }
}

