/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.micronaut;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.ConversionService;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.redisson.MapCacheNativeWrapper;
import org.redisson.Redisson;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RMapCacheNative;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.config.Config;
import org.redisson.micronaut.cache.RedissonCacheConfiguration;
import org.redisson.micronaut.cache.RedissonCacheNativeConfiguration;
import org.redisson.micronaut.cache.RedissonSyncCache;

@Factory
public class RedissonFactory {
    @Requires(beans={Config.class})
    @Singleton
    @Bean(preDestroy="shutdown")
    public RedissonClient redisson(Config config) {
        return Redisson.create((Config)config);
    }

    @EachBean(value=RedissonCacheConfiguration.class)
    public RedissonSyncCache cache(@Parameter RedissonCacheConfiguration configuration, RedissonClient redisson, ConversionService conversionService, @Named(value="io") ExecutorService executorService) {
        Codec codec = Optional.ofNullable(configuration.getCodec()).orElse(redisson.getConfig().getCodec());
        if (configuration.getExpireAfterAccess().toMillis() != 0L || configuration.getExpireAfterWrite().toMillis() != 0L || configuration.getMaxSize() != 0) {
            RMapCache mapCache = redisson.getMapCache(configuration.getName(), codec);
            return new RedissonSyncCache(conversionService, (RMapCache<Object, Object>)mapCache, (RMap<Object, Object>)mapCache, executorService, configuration);
        }
        RMap map = redisson.getMap(configuration.getName(), codec);
        return new RedissonSyncCache(conversionService, null, (RMap<Object, Object>)map, executorService, configuration);
    }

    @EachBean(value=RedissonCacheNativeConfiguration.class)
    public RedissonSyncCache cache(@Parameter RedissonCacheNativeConfiguration configuration, RedissonClient redisson, ConversionService conversionService, @Named(value="io") ExecutorService executorService) {
        MapCacheNativeWrapper mapCache = null;
        RMapCacheNative map = redisson.getMapCacheNative(configuration.getMapOptions());
        if (configuration.getExpireAfterWrite().toMillis() != 0L) {
            mapCache = new MapCacheNativeWrapper(map);
        }
        return new RedissonSyncCache(conversionService, (RMapCache<Object, Object>)mapCache, (RMap<Object, Object>)map, executorService, configuration);
    }
}

