/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.micronaut;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.PropertySourcePropertyResolver;
import jakarta.inject.Inject;
import java.util.Collection;
import org.redisson.client.NettyHook;
import org.redisson.client.codec.Codec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.connection.AddressResolverGroupFactory;
import org.redisson.connection.ConnectionListener;

@ConfigurationProperties(value="redisson")
@Requirements(value={@Requires(missingBeans={Config.class}), @Requires(property="redisson")})
public class RedissonConfiguration
extends Config {
    @Inject
    public RedissonConfiguration(PropertySourcePropertyResolver propertyResolver) {
        Collection m = propertyResolver.getPropertyEntries("redisson");
        if (m.contains("cluster-servers-config")) {
            this.useClusterServers();
        }
        if (m.contains("single-server-config")) {
            this.useSingleServer();
        }
        if (m.contains("replicated-servers-config")) {
            this.useReplicatedServers();
        }
        if (m.contains("sentinel-servers-config")) {
            this.useSentinelServers();
        }
        if (m.contains("master-slave-servers-config")) {
            this.useMasterSlaveServers();
        }
        if (m.contains("codec")) {
            this.setCodec((String)propertyResolver.getProperty("redisson.codec", String.class).get());
        }
        if (m.contains("address-resolver-group-factory")) {
            this.setAddressResolverGroupFactory((String)propertyResolver.getProperty("redisson.address-resolver-group-factory", String.class).get());
        }
        if (m.contains("connection-listener")) {
            this.setConnectionListener((String)propertyResolver.getProperty("redisson.connection-listener", String.class).get());
        }
        if (m.contains("nettyHook")) {
            this.setNettyHook((String)propertyResolver.getProperty("redisson.netty-hook", String.class).get());
        }
    }

    @ConfigurationBuilder(value="singleServerConfig")
    public SingleServerConfig getSingleServerConfig() {
        return super.getSingleServerConfig();
    }

    @ConfigurationBuilder(value="clusterServersConfig")
    public ClusterServersConfig getClusterServersConfig() {
        return super.getClusterServersConfig();
    }

    @ConfigurationBuilder(value="replicatedServersConfig")
    public ReplicatedServersConfig getReplicatedServersConfig() {
        return super.getReplicatedServersConfig();
    }

    @ConfigurationBuilder(value="sentinelServersConfig")
    public SentinelServersConfig getSentinelServersConfig() {
        return super.getSentinelServersConfig();
    }

    @ConfigurationBuilder(value="masterSlaveServersConfig")
    public MasterSlaveServersConfig getMasterSlaveServersConfig() {
        return super.getMasterSlaveServersConfig();
    }

    public Config setCodec(String className) {
        try {
            Codec codec = (Codec)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return super.setCodec(codec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Config setNettyHook(String className) {
        try {
            NettyHook nettyHook = (NettyHook)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return super.setNettyHook(nettyHook);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Config setAddressResolverGroupFactory(String className) {
        try {
            AddressResolverGroupFactory value = (AddressResolverGroupFactory)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return super.setAddressResolverGroupFactory(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Config setConnectionListener(String className) {
        try {
            ConnectionListener connectionListener = (ConnectionListener)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return super.setConnectionListener(connectionListener);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

