/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.micronaut.session;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.session.InMemorySession;
import io.micronaut.session.Session;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBatch;
import org.redisson.api.RBucketAsync;
import org.redisson.api.RMap;
import org.redisson.api.RMapAsync;
import org.redisson.api.RTopic;
import org.redisson.api.RTopicAsync;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.IntegerCodec;
import org.redisson.micronaut.session.AttributeRemoveMessage;
import org.redisson.micronaut.session.AttributeUpdateMessage;
import org.redisson.micronaut.session.AttributesClearMessage;
import org.redisson.micronaut.session.AttributesPutAllMessage;
import org.redisson.micronaut.session.RedissonHttpSessionConfiguration;
import org.redisson.micronaut.session.RedissonSessionStore;

public class RedissonSession
extends InMemorySession
implements Session {
    private static final String MAX_INACTIVE_INTERVAL_ATTR = "session:maxInactiveInterval";
    private static final String LAST_ACCESSED_TIME_ATTR = "session:lastAccessedTime";
    private static final String CREATION_TIME_ATTR = "session:creationTime";
    private final RedissonSessionStore redissonManager;
    private final RMap<CharSequence, Object> map;
    private final RTopic topic;
    private final RedissonHttpSessionConfiguration.UpdateMode updateMode;
    private Instant creationTime;
    private boolean broadcastSessionUpdates;
    private Set<String> removedAttributes = Collections.emptySet();
    private Map<String, Object> updatedAttributes = Collections.emptyMap();

    public RedissonSession(RedissonSessionStore redissonManager, String id, RedissonHttpSessionConfiguration.UpdateMode updateMode) {
        this(redissonManager, id, updateMode, Duration.ZERO);
    }

    public RedissonSession(RedissonSessionStore redissonManager, String id, RedissonHttpSessionConfiguration.UpdateMode updateMode, Duration maxInactiveInterval) {
        super(id, maxInactiveInterval);
        this.redissonManager = redissonManager;
        this.updateMode = updateMode;
        this.topic = redissonManager.getTopic();
        if (updateMode == RedissonHttpSessionConfiguration.UpdateMode.AFTER_REQUEST) {
            this.removedAttributes = Collections.newSetFromMap(new ConcurrentHashMap());
            this.updatedAttributes = new ConcurrentHashMap<String, Object>();
        }
        this.creationTime = super.getCreationTime();
        super.setLastAccessedTime(this.creationTime);
        this.map = redissonManager.getMap(this.getId());
    }

    @NonNull
    public Instant getCreationTime() {
        return this.creationTime;
    }

    public MutableConvertibleValues<Object> clear() {
        if (!this.isNew()) {
            this.removedAttributes.addAll(this.names());
            if (this.updateMode == RedissonHttpSessionConfiguration.UpdateMode.WRITE_BEHIND && this.map != null) {
                this.delete();
            }
        }
        return super.clear();
    }

    public CompletableFuture<Void> delete() {
        RBatch batch = this.redissonManager.createBatch();
        RMapAsync m = batch.getMap(this.map.getName(), this.map.getCodec());
        RBucketAsync b = batch.getBucket(this.redissonManager.getNotificationBucket(this.getId()).getName(), (Codec)IntegerCodec.INSTANCE);
        b.deleteAsync();
        m.fastPutAsync((Object)LAST_ACCESSED_TIME_ATTR, (Object)0L);
        m.expireAsync(10L, TimeUnit.SECONDS);
        if (this.broadcastSessionUpdates) {
            RTopicAsync t = batch.getTopic((String)this.topic.getChannelNames().get(0));
            t.publishAsync((Object)new AttributesClearMessage(this.redissonManager.getNodeId(), this.getId()));
        }
        return batch.executeAsync().thenApply(s -> null).toCompletableFuture();
    }

    protected void expireSession() {
        if (this.getMaxInactiveInterval().getSeconds() >= 0L) {
            RBatch batch = this.redissonManager.createBatch();
            RMapAsync m = batch.getMap(this.map.getName(), this.map.getCodec());
            RBucketAsync b = batch.getBucket(this.redissonManager.getNotificationBucket(this.getId()).getName(), (Codec)IntegerCodec.INSTANCE);
            b.setAsync((Object)1);
            b.expireAsync(this.getMaxInactiveInterval().getSeconds(), TimeUnit.SECONDS);
            m.expireAsync(this.getMaxInactiveInterval().getSeconds() + 10L, TimeUnit.SECONDS);
            batch.executeAsync();
        }
    }

    protected AttributesPutAllMessage createPutAllMessage(Map<CharSequence, Object> newMap) {
        HashMap<CharSequence, Object> map = new HashMap<CharSequence, Object>();
        for (Map.Entry<CharSequence, Object> entry : newMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        try {
            return new AttributesPutAllMessage(this.redissonManager.getNodeId(), this.getId(), map, this.map.getCodec().getMapValueEncoder());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Session setMaxInactiveInterval(Duration duration) {
        if (this.updateMode == RedissonHttpSessionConfiguration.UpdateMode.WRITE_BEHIND && this.map != null) {
            this.fastPut(MAX_INACTIVE_INTERVAL_ATTR, duration.toMillis());
            this.expireSession();
        }
        if (this.updateMode == RedissonHttpSessionConfiguration.UpdateMode.AFTER_REQUEST) {
            this.updatedAttributes.put(MAX_INACTIVE_INTERVAL_ATTR, duration.toMillis());
        }
        return super.setMaxInactiveInterval(duration);
    }

    private void fastPut(String name, Object value) {
        if (this.map == null) {
            return;
        }
        this.map.fastPutAsync((Object)name, value);
        try {
            if (this.broadcastSessionUpdates) {
                this.topic.publishAsync((Object)new AttributeUpdateMessage(this.redissonManager.getNodeId(), this.getId(), name, value, this.map.getCodec().getMapValueEncoder()));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Session setLastAccessedTime(Instant instant) {
        if (this.updateMode == RedissonHttpSessionConfiguration.UpdateMode.WRITE_BEHIND && this.map != null) {
            this.fastPut(LAST_ACCESSED_TIME_ATTR, instant.toEpochMilli());
            this.expireSession();
        }
        if (this.updateMode == RedissonHttpSessionConfiguration.UpdateMode.AFTER_REQUEST) {
            this.updatedAttributes.put(LAST_ACCESSED_TIME_ATTR, instant.toEpochMilli());
        }
        return super.setLastAccessedTime(instant);
    }

    public void superPut(CharSequence name, Object value) {
        super.put(name, value);
    }

    public MutableConvertibleValues<Object> put(CharSequence key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        if (this.updateMode == RedissonHttpSessionConfiguration.UpdateMode.WRITE_BEHIND && this.map != null) {
            this.fastPut(key.toString(), value);
        }
        if (this.updateMode == RedissonHttpSessionConfiguration.UpdateMode.AFTER_REQUEST) {
            this.updatedAttributes.put(key.toString(), value);
            this.removedAttributes.remove(key.toString());
        }
        return super.put(key, value);
    }

    public void superRemove(CharSequence key) {
        super.remove(key);
    }

    public MutableConvertibleValues<Object> remove(CharSequence key) {
        if (this.updateMode == RedissonHttpSessionConfiguration.UpdateMode.WRITE_BEHIND && this.map != null) {
            this.map.fastRemoveAsync((Object[])new CharSequence[]{key.toString()});
            if (this.broadcastSessionUpdates) {
                this.topic.publishAsync((Object)new AttributeRemoveMessage(this.redissonManager.getNodeId(), this.getId(), new HashSet<CharSequence>(Arrays.asList(key))));
            }
        }
        if (this.updateMode == RedissonHttpSessionConfiguration.UpdateMode.AFTER_REQUEST) {
            this.updatedAttributes.remove(key.toString());
            this.removedAttributes.add(key.toString());
        }
        return super.remove(key);
    }

    public CompletableFuture<RedissonSession> save() {
        HashMap<CharSequence, Object> newMap = new HashMap<CharSequence, Object>();
        if (this.isNew() || this.updateMode == RedissonHttpSessionConfiguration.UpdateMode.WRITE_BEHIND) {
            newMap.put(LAST_ACCESSED_TIME_ATTR, this.getLastAccessedTime().toEpochMilli());
            newMap.put(MAX_INACTIVE_INTERVAL_ATTR, this.getMaxInactiveInterval().toMillis());
            newMap.put(CREATION_TIME_ATTR, this.getCreationTime().toEpochMilli());
            for (Map.Entry entry : this.attributeMap.entrySet()) {
                newMap.put((CharSequence)entry.getKey(), entry.getValue());
            }
        } else {
            newMap.putAll(this.updatedAttributes);
        }
        if (newMap.isEmpty()) {
            return CompletableFuture.completedFuture(this);
        }
        RBatch batch = this.redissonManager.createBatch();
        RMapAsync m = batch.getMap(this.map.getName(), this.map.getCodec());
        m.putAllAsync(newMap);
        m.fastRemoveAsync((Object[])this.removedAttributes.toArray(new String[0]));
        RBucketAsync bucket = batch.getBucket(this.redissonManager.getNotificationBucket(this.getId()).getName(), (Codec)IntegerCodec.INSTANCE);
        bucket.setAsync((Object)1);
        if (this.broadcastSessionUpdates) {
            RTopicAsync t = batch.getTopic((String)this.topic.getChannelNames().get(0));
            t.publishAsync((Object)this.createPutAllMessage(newMap));
            if (this.updateMode == RedissonHttpSessionConfiguration.UpdateMode.AFTER_REQUEST && !this.removedAttributes.isEmpty()) {
                t.publishAsync((Object)new AttributeRemoveMessage(this.redissonManager.getNodeId(), this.getId(), new HashSet<CharSequence>(this.removedAttributes)));
            }
        }
        this.removedAttributes.clear();
        this.updatedAttributes.clear();
        if (this.getMaxInactiveInterval().getSeconds() >= 0L) {
            bucket.expireAsync(this.getMaxInactiveInterval().getSeconds(), TimeUnit.SECONDS);
            m.expireAsync(this.getMaxInactiveInterval().getSeconds() + 10L, TimeUnit.SECONDS);
        }
        return batch.executeAsync().thenApply(b -> this).toCompletableFuture();
    }

    public void load(Map<CharSequence, Object> attrs) {
        Long maxInactiveInterval;
        Long lastAccessedTime;
        Long creationTime = (Long)attrs.remove(CREATION_TIME_ATTR);
        if (creationTime != null) {
            this.creationTime = Instant.ofEpochMilli(creationTime);
        }
        if ((lastAccessedTime = (Long)attrs.remove(LAST_ACCESSED_TIME_ATTR)) != null) {
            super.setLastAccessedTime(Instant.ofEpochMilli(lastAccessedTime));
        }
        if ((maxInactiveInterval = (Long)attrs.remove(MAX_INACTIVE_INTERVAL_ATTR)) != null) {
            super.setMaxInactiveInterval(Duration.ofMillis(maxInactiveInterval));
        }
        this.setNew(false);
        for (Map.Entry<CharSequence, Object> entry : attrs.entrySet()) {
            this.attributeMap.put(entry.getKey(), entry.getValue());
        }
    }
}

