/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.micronaut.cache;

import io.micronaut.cache.AbstractMapBasedSyncCache;
import io.micronaut.cache.AsyncCache;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.micronaut.cache.BaseCacheConfiguration;
import org.redisson.micronaut.cache.RedissonAsyncCache;

public class RedissonSyncCache
extends AbstractMapBasedSyncCache<RMap<Object, Object>> {
    private final ConversionService<?> conversionService;
    private final ExecutorService executorService;
    private final BaseCacheConfiguration configuration;
    private final RMapCache<Object, Object> mapCache;
    private final RMap<Object, Object> map;

    public RedissonSyncCache(ConversionService<?> conversionService, RMapCache<Object, Object> mapCache, RMap<Object, Object> map, ExecutorService executorService, BaseCacheConfiguration configuration) {
        super(conversionService, map);
        this.executorService = executorService;
        this.configuration = configuration;
        this.mapCache = mapCache;
        this.map = map;
        this.conversionService = conversionService;
        if (configuration.getMaxSize() != 0) {
            mapCache.setMaxSize(configuration.getMaxSize());
        }
    }

    public String getName() {
        return ((RMap)this.getNativeCache()).getName();
    }

    @NonNull
    public <T> Optional<T> putIfAbsent(@NonNull Object key, @NonNull T value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        ArgumentUtils.requireNonNull((String)"value", value);
        Object res = this.mapCache != null ? this.mapCache.putIfAbsent(key, value, this.configuration.getExpireAfterWrite().toMillis(), TimeUnit.MILLISECONDS, this.configuration.getExpireAfterAccess().toMillis(), TimeUnit.MILLISECONDS) : this.mapCache.putIfAbsent(key, value);
        return Optional.ofNullable(res);
    }

    @NonNull
    public <T> T putIfAbsent(@NonNull Object key, @NonNull Supplier<T> value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        ArgumentUtils.requireNonNull((String)"value", value);
        T val = value.get();
        Object res = this.mapCache != null ? this.mapCache.putIfAbsent(key, val, this.configuration.getExpireAfterWrite().toMillis(), TimeUnit.MILLISECONDS, this.configuration.getExpireAfterAccess().toMillis(), TimeUnit.MILLISECONDS) : this.mapCache.putIfAbsent(key, value);
        return (T)Optional.ofNullable(res).orElse(val);
    }

    public void put(@NonNull Object key, @NonNull Object value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        ArgumentUtils.requireNonNull((String)"value", (Object)value);
        if (this.mapCache != null) {
            this.mapCache.fastPut(key, value, this.configuration.getExpireAfterWrite().toMillis(), TimeUnit.MILLISECONDS, this.configuration.getExpireAfterAccess().toMillis(), TimeUnit.MILLISECONDS);
        } else {
            this.mapCache.fastPut(key, value);
        }
    }

    @NonNull
    public AsyncCache<RMap<Object, Object>> async() {
        return new RedissonAsyncCache(this.mapCache, this.map, this.executorService, this.conversionService);
    }
}

