/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.strategy;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.redisson.api.RMapCache;
import org.redisson.hibernate.region.RedissonNaturalIdRegion;
import org.redisson.hibernate.strategy.AbstractReadWriteAccessStrategy;

public class ReadWriteNaturalIdRegionAccessStrategy
extends AbstractReadWriteAccessStrategy
implements NaturalIdRegionAccessStrategy {
    public ReadWriteNaturalIdRegionAccessStrategy(Settings settings, GeneralDataRegion region, RMapCache<Object, Object> mapCache) {
        super(settings, region, mapCache);
    }

    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)this.region;
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        this.region.put(session, key, value);
        return true;
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        this.region.put(session, key, value);
        return true;
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return ((RedissonNaturalIdRegion)this.region).getCacheKeysFactory().createNaturalIdKey(naturalIdValues, persister, session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return ((RedissonNaturalIdRegion)this.region).getCacheKeysFactory().getNaturalIdValues(cacheKey);
    }
}

