/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.region;

import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cfg.Settings;
import org.redisson.api.RMapCache;
import org.redisson.hibernate.region.BaseRegion;
import org.redisson.hibernate.strategy.NonStrictReadWriteEntityRegionAccessStrategy;
import org.redisson.hibernate.strategy.ReadOnlyEntityRegionAccessStrategy;
import org.redisson.hibernate.strategy.ReadWriteEntityRegionAccessStrategy;
import org.redisson.hibernate.strategy.TransactionalEntityRegionAccessStrategy;

public class RedissonEntityRegion
extends BaseRegion
implements EntityRegion {
    private final Settings settings;

    public RedissonEntityRegion(RMapCache<Object, Object> mapCache, RegionFactory regionFactory, CacheDataDescription metadata, Settings settings, Properties properties, String defaultKey) {
        super(mapCache, regionFactory, metadata, properties, defaultKey);
        this.settings = settings;
    }

    public EntityRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        if (accessType == AccessType.READ_ONLY) {
            return new ReadOnlyEntityRegionAccessStrategy(this.settings, this);
        }
        if (accessType == AccessType.READ_WRITE) {
            return new ReadWriteEntityRegionAccessStrategy(this.settings, this, (RMapCache<Object, Object>)this.mapCache);
        }
        if (accessType == AccessType.NONSTRICT_READ_WRITE) {
            return new NonStrictReadWriteEntityRegionAccessStrategy(this.settings, this);
        }
        if (accessType == AccessType.TRANSACTIONAL) {
            return new TransactionalEntityRegionAccessStrategy(this.settings, this);
        }
        throw new CacheException("Unsupported access strategy: " + accessType);
    }
}

