/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.renewal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.redisson.api.RFuture;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.decoder.ContainsDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.AsyncChunkProcessor;
import org.redisson.renewal.LockTask;
import org.redisson.renewal.ReadLockEntry;

public class ReadLockTask
extends LockTask {
    public ReadLockTask(long internalLockLeaseTime, CommandAsyncExecutor executor, int chunkSize) {
        super(internalLockLeaseTime, executor, chunkSize);
    }

    @Override
    CompletionStage<Void> renew(Iterator<String> iter, int chunkSize) {
        return AsyncChunkProcessor.processAll(iter, chunkSize, this::buildChunk);
    }

    private AsyncChunkProcessor.ChunkExecution<List<Object>> buildChunk(Iterator<String> iter, int chunkSize) {
        HashMap<String, Long> name2lockName = new HashMap<String, Long>();
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.internalLockLeaseTime);
        ArrayList<String> keys = new ArrayList<String>(chunkSize);
        ArrayList<Object> keysArgs = new ArrayList<Object>(chunkSize);
        while (iter.hasNext() && keys.size() < chunkSize) {
            Long threadId;
            String key = iter.next();
            ReadLockEntry entry = (ReadLockEntry)this.name2entry.get(key);
            if (entry == null || (threadId = entry.getFirstThreadId()) == null) continue;
            String keyPrefix = entry.getKeyPrefix(threadId);
            String lockName = entry.getLockName(threadId);
            if (keyPrefix == null || lockName == null) continue;
            keys.add(key);
            keysArgs.add(key);
            keysArgs.add(keyPrefix);
            args.add(lockName);
            name2lockName.put(key, threadId);
        }
        if (keys.isEmpty()) {
            return null;
        }
        String firstName = keys.get(0).toString();
        RFuture f = this.executor.syncedEval(firstName, LongCodec.INSTANCE, new RedisCommand("EVAL", new ContainsDecoder(keys)), "local result = {} local j = 1 for i = 1, #KEYS, 2 do j = j + 1; local counter = redis.call('hget', KEYS[i], ARGV[j]); if (counter ~= false) then redis.call('pexpire', KEYS[i], ARGV[1]); if (redis.call('hlen', KEYS[i]) > 1) then local keys = redis.call('hkeys', KEYS[i]); for n, key in ipairs(keys) do counter = tonumber(redis.call('hget', KEYS[i], key)); if type(counter) == 'number' then for c=counter, 1, -1 do redis.call('pexpire', KEYS[i+1] .. ':' .. key .. ':rwlock_timeout:' .. c, ARGV[1]); end; end; end; end; table.insert(result, 1); else table.insert(result, 0); end; end; return result;", keysArgs, args.toArray());
        return new AsyncChunkProcessor.ChunkExecution<List<Object>>(f, existingNames -> {
            keys.removeAll((Collection<?>)existingNames);
            for (Object k : keys) {
                String key = k.toString();
                this.cancelExpirationRenewal(key, (Long)name2lockName.get(key));
            }
        });
    }

    public void add(String rawName, String lockName, long threadId, String keyPrefix) {
        this.addSlotName(rawName);
        ReadLockEntry entry = new ReadLockEntry();
        entry.addThreadId(threadId, lockName, keyPrefix);
        ReadLockEntry oldEntry = this.name2entry.putIfAbsent(rawName, entry);
        if (oldEntry != null) {
            oldEntry.addThreadId(threadId, lockName, keyPrefix);
        } else if (this.tryRun()) {
            this.schedule();
        }
    }
}

