/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public final class AsyncIteratorUtils {
    private AsyncIteratorUtils() {
    }

    public static <T> CompletionStage<Void> forEachAsync(Iterator<T> iter, Function<T, CompletionStage<Void>> processor) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        AsyncIteratorUtils.processNext(iter, processor, result);
        return result;
    }

    private static <T> void processNext(Iterator<T> iter, Function<T, CompletionStage<Void>> processor, CompletableFuture<Void> result) {
        CompletableFuture<Void> cf;
        block6: {
            do {
                if (!iter.hasNext()) {
                    result.complete(null);
                    return;
                }
                T element = iter.next();
                CompletionStage<Void> stage = processor.apply(element);
                cf = stage.toCompletableFuture();
                if (!cf.isDone()) break block6;
            } while (!cf.isCompletedExceptionally());
            try {
                cf.join();
            }
            catch (CompletionException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                result.completeExceptionally(cause);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
            return;
        }
        cf.whenComplete((r, ex) -> {
            if (ex != null) {
                result.completeExceptionally(AsyncIteratorUtils.unwrap(ex));
                return;
            }
            AsyncIteratorUtils.processNext(iter, processor, result);
        });
    }

    private static Throwable unwrap(Throwable ex) {
        if (ex instanceof CompletionException && ex.getCause() != null) {
            return ex.getCause();
        }
        return ex;
    }
}

