/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public final class AsyncChunkProcessor {
    private AsyncChunkProcessor() {
    }

    public static <R> CompletionStage<Void> processAll(Iterator<String> iter, int chunkSize, BiFunction<Iterator<String>, Integer, ChunkExecution<R>> chunkHandler) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        AsyncChunkProcessor.processNext(iter, chunkSize, chunkHandler, result);
        return result;
    }

    private static <R> void processNext(Iterator<String> iter, int chunkSize, BiFunction<Iterator<String>, Integer, ChunkExecution<R>> chunkHandler, CompletableFuture<Void> result) {
        CompletableFuture<R> cf;
        ChunkExecution execution;
        while (true) {
            if ((execution = chunkHandler.apply(iter, chunkSize)) == null) {
                result.complete(null);
                return;
            }
            cf = execution.future().toCompletableFuture();
            if (!cf.isDone()) break;
            if (cf.isCompletedExceptionally()) {
                AsyncChunkProcessor.propagateException(cf, result);
                return;
            }
            execution.onSuccess().accept(cf.join());
        }
        cf.whenComplete((r, ex) -> {
            if (ex != null) {
                result.completeExceptionally(AsyncChunkProcessor.unwrap(ex));
                return;
            }
            execution.onSuccess().accept(r);
            AsyncChunkProcessor.processNext(iter, chunkSize, chunkHandler, result);
        });
    }

    private static void propagateException(CompletableFuture<?> cf, CompletableFuture<Void> result) {
        try {
            cf.join();
        }
        catch (CompletionException e) {
            result.completeExceptionally(AsyncChunkProcessor.unwrap(e));
        }
        catch (Exception e) {
            result.completeExceptionally(e);
        }
    }

    private static Throwable unwrap(Throwable ex) {
        if (ex instanceof CompletionException && ex.getCause() != null) {
            return ex.getCause();
        }
        return ex;
    }

    public static final class ChunkExecution<R> {
        private final CompletionStage<R> future;
        private final Consumer<R> onSuccess;

        public ChunkExecution(CompletionStage<R> future, Consumer<R> onSuccess) {
            this.future = future;
            this.onSuccess = onSuccess;
        }

        public CompletionStage<R> future() {
            return this.future;
        }

        public Consumer<R> onSuccess() {
            return this.onSuccess;
        }
    }
}

