/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.balancer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.balancer.LoadBalancer;
import org.redisson.misc.RedisURI;
import org.redisson.misc.WrappedLock;

public class WeightedRoundRobinBalancer
implements LoadBalancer {
    private final AtomicInteger index = new AtomicInteger(-1);
    private final Map<RedisURI, WeightEntry> weights = new ConcurrentHashMap<RedisURI, WeightEntry>();
    private final int defaultWeight;
    private final WrappedLock lock = new WrappedLock();

    public WeightedRoundRobinBalancer(Map<String, Integer> weights, int defaultWeight) {
        for (Map.Entry<String, Integer> entry : weights.entrySet()) {
            RedisURI uri = new RedisURI(entry.getKey());
            if (entry.getValue() <= 0) {
                throw new IllegalArgumentException("Weight can't be less than or equal zero");
            }
            this.weights.put(uri, new WeightEntry(entry.getValue()));
        }
        if (defaultWeight <= 0) {
            throw new IllegalArgumentException("Weight can't be less than or equal zero");
        }
        this.defaultWeight = defaultWeight;
    }

    @Override
    public ClientConnectionsEntry getEntry(List<ClientConnectionsEntry> clients) {
        List<ClientConnectionsEntry> usedClients = this.findClients(clients, this.weights);
        for (ClientConnectionsEntry e : clients) {
            if (usedClients.contains(e)) continue;
            this.weights.put(e.getClient().getConfig().getAddress(), new WeightEntry(this.defaultWeight));
        }
        return this.lock.execute(() -> {
            List<ClientConnectionsEntry> clientsCopy;
            Map<RedisURI, WeightEntry> weightsCopy = new HashMap<RedisURI, WeightEntry>(this.weights);
            weightsCopy.values().removeIf(WeightEntry::isWeightCounterZero);
            if (weightsCopy.isEmpty()) {
                for (WeightEntry weightEntry : this.weights.values()) {
                    weightEntry.resetWeightCounter();
                }
                weightsCopy = this.weights;
            }
            if ((clientsCopy = this.findClients(clients, weightsCopy)).isEmpty()) {
                for (WeightEntry weightEntry : this.weights.values()) {
                    weightEntry.resetWeightCounter();
                }
                weightsCopy = this.weights;
                clientsCopy = this.findClients(clients, weightsCopy);
            }
            int n = Math.floorMod(this.index.incrementAndGet(), clientsCopy.size());
            ClientConnectionsEntry clientConnectionsEntry = clientsCopy.get(n);
            for (Map.Entry<RedisURI, WeightEntry> weightEntry : weightsCopy.entrySet()) {
                if (!weightEntry.getKey().equals(clientConnectionsEntry.getClient().getAddr())) continue;
                weightEntry.getValue().decWeightCounter();
                break;
            }
            return clientConnectionsEntry;
        });
    }

    private List<ClientConnectionsEntry> findClients(List<ClientConnectionsEntry> clients, Map<RedisURI, WeightEntry> weightsCopy) {
        return clients.stream().filter(e -> {
            for (RedisURI redisURI : weightsCopy.keySet()) {
                if (!redisURI.equals(e.getClient().getAddr())) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    static class WeightEntry {
        final int weight;
        int weightCounter;

        WeightEntry(int weight) {
            this.weight = weight;
            this.weightCounter = weight;
        }

        public boolean isWeightCounterZero() {
            return this.weightCounter == 0;
        }

        public void decWeightCounter() {
            --this.weightCounter;
        }

        public void resetWeightCounter() {
            this.weightCounter = this.weight;
        }
    }
}

